/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.batch.ui.editor.contentassist.batch;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.batch.BatchUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StepReferenceContentAssistCalculator
implements IContentAssistCalculator {
    private static final int RELEVANCE = 20;

    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String prefix = context.getMatchString();
        if (prefix == null) {
            prefix = "";
        }
        IFile file = context.getFile();
        if (context.getDocument() != null) {
            this.searchStepElements(recorder, prefix, context.getParentNode(), file);
            if (context.getNode() != null && ("next".equals(context.getNode().getNodeName()) || "stop".equals(context.getNode().getNodeName()))) {
                this.searchStepElements(recorder, prefix, context.getParentNode().getParentNode(), file);
            }
        }
    }

    private void searchStepElements(IContentAssistProposalRecorder recorder, String prefix, Node node, IFile file) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap attributes;
            Node id;
            Node child = children.item(i);
            if (("step".equals(child.getLocalName()) || "decision".equals(child.getLocalName()) || "split".equals(child.getLocalName())) && (id = (attributes = child.getAttributes()).getNamedItem("id")) != null && id.getNodeValue() != null && id.getNodeValue().startsWith(prefix)) {
                this.acceptStepMatch(recorder, child, file);
            }
            ++i;
        }
    }

    private void acceptStepMatch(IContentAssistProposalRecorder recorder, Node stepNode, IFile file) {
        String stepName;
        NamedNodeMap attrs = stepNode.getAttributes();
        Node id = attrs.getNamedItem("id");
        Node parentNode = stepNode.getParentNode();
        String replaceText = stepName = id.getNodeValue();
        String fileName = file.getProjectRelativePath().toString();
        StringBuilder buf = new StringBuilder();
        buf.append(stepName);
        if (parentNode != null) {
            buf.append(" [");
            buf.append(parentNode.getNodeName());
            buf.append("]");
        }
        if (fileName != null) {
            buf.append(" - ");
            buf.append(fileName);
        }
        String displayText = buf.toString();
        Image image = BatchUIImages.getImage("org.springframework.ide.eclipse.batch.spring_batch_obj.gif");
        recorder.recordProposal(image, 20, displayText, replaceText, (Object)stepName);
    }
}

