/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import com.eclipsesource.json.JsonArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import tern.TernFileManager;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.core.scriptpath.IScriptResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.scriptpath.AbstractTernScriptPath;
import tern.server.protocol.TernDoc;

public class ProjectScriptPath
extends AbstractTernScriptPath {
    private final IProject ownerProject;
    private final Collection<IScriptResource> scripts;

    public ProjectScriptPath(IProject project, IProject ownerProject, String external) {
        super((IResource)project, ITernScriptPath.ScriptPathsType.PROJECT, external);
        this.ownerProject = ownerProject;
        this.scripts = new ArrayList<IScriptResource>();
    }

    @Override
    public IProject getOwnerProject() {
        return this.ownerProject;
    }

    @Override
    public String getPath() {
        return ((IProject)this.getResource()).getName();
    }

    @Override
    public Collection<IScriptResource> getScriptResources() {
        this.scripts.clear();
        IProject project = (IProject)this.getResource();
        try {
            IIDETernProject ternProject = TernCorePlugin.getTernProject(project);
            Collection<ITernScriptPath> scriptPaths = ternProject.getScriptPaths();
            for (ITernScriptPath scriptPath : scriptPaths) {
                this.scripts.addAll(scriptPath.getScriptResources());
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while retrieving script resources from the project script path " + project.getName(), e);
        }
        return this.scripts;
    }

    @Override
    public void updateFiles(TernFileManager ternFileManager, TernDoc doc, JsonArray names) throws IOException {
        IProject project = (IProject)this.getResource();
        try {
            IIDETernProject ternProject = TernCorePlugin.getTernProject(project);
            Collection<ITernScriptPath> scriptPaths = ternProject.getScriptPaths();
            for (ITernScriptPath scriptPath : scriptPaths) {
                if (scriptPath.getType() == ITernScriptPath.ScriptPathsType.PROJECT && scriptPath.getOwnerProject().equals((Object)project)) continue;
                scriptPath.updateFiles(ternFileManager, doc, names);
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while updating files script resources from the project script path " + project.getName(), e);
        }
    }
}

