/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.scriptpath;

import com.eclipsesource.json.JsonArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tern.TernFileManager;
import tern.eclipse.ide.core.dom.DOMProviderHelper;
import tern.eclipse.ide.core.scriptpath.IScriptResource;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.AbstractTernScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.DOMAbsoluteURLScriptResource;
import tern.eclipse.ide.internal.core.scriptpath.DOMContentScriptResource;
import tern.eclipse.ide.internal.core.scriptpath.DOMRelativeURLScriptResource;
import tern.server.protocol.TernDoc;
import tern.utils.StringUtils;

public class DOMElementsScriptPath
extends AbstractTernScriptPath {
    private static final String SCRIPT_ELT = "script";
    private static final String HTTP_ATTR = "http";
    private static final String SRC_ATTR = "src";

    public DOMElementsScriptPath(IFile resource, String external) {
        super((IResource)resource, ITernScriptPath.ScriptPathsType.FILE, external);
    }

    @Override
    public Collection<IScriptResource> getScriptResources() {
        ArrayList<IScriptResource> resources = new ArrayList<IScriptResource>();
        Document document = this.getDocument();
        if (document != null) {
            int localScriptNb = 0;
            Element scriptElt = null;
            String src = null;
            NodeList scripts = document.getElementsByTagName(SCRIPT_ELT);
            int i = 0;
            while (i < scripts.getLength()) {
                scriptElt = (Element)scripts.item(i);
                src = scriptElt.getAttribute(SRC_ATTR);
                if (StringUtils.isEmpty((String)src)) {
                    resources.add(new DOMContentScriptResource((IFile)this.getResource(), localScriptNb++));
                } else if (src.startsWith(HTTP_ATTR)) {
                    resources.add(new DOMAbsoluteURLScriptResource(src));
                } else {
                    resources.add(new DOMRelativeURLScriptResource((IFile)this.getResource(), src));
                }
                ++i;
            }
        }
        return resources;
    }

    @Override
    public void updateFiles(TernFileManager ternFileManager, TernDoc doc, JsonArray names) throws IOException {
        Document element = this.getDocument();
        ternFileManager.updateFiles((Node)element, (Object)this.getResource(), doc, names);
    }

    public Document getDocument() {
        return DOMProviderHelper.getProvider().getDocument((IFile)this.getResource());
    }
}

