/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.livexp.Activator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class ProjectLocationSection
extends WizardPageSection {
    private static final String SAVED_LOCATION_ATTR = "OUTSIDE_LOCATION";
    private final LiveExpression<String> projectName;
    private final LiveExpression<ValidationResult> validator;
    private final LiveVariable<String> location;
    private Button useDefaultsButton;
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;

    private void refreshLocation() {
        if (this.isDefault()) {
            this.location.setValue(this.getDefaultPathDisplayString());
        } else {
            this.location.setValue(this.locationPathField.getText());
        }
    }

    public ProjectLocationSection(IPageWithSections owner, LiveVariable<String> location, LiveExpression<String> projectName, LiveExpression<ValidationResult> validator) {
        super(owner);
        this.projectName = projectName;
        this.location = location;
        this.validator = validator;
    }

    private boolean isDefault() {
        if (this.useDefaultsButton != null) {
            return this.useDefaultsButton.getSelection();
        }
        return true;
    }

    public LiveExpression<String> getLocation() {
        return this.location;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    @Override
    public void createContents(Composite page) {
        boolean defaultEnabled = true;
        int columns = 4;
        Composite projectGroup = new Composite(page, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText("Use default location");
        this.useDefaultsButton.setSelection(defaultEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserEntryArea(projectGroup, defaultEnabled);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = ProjectLocationSection.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    ProjectLocationSection.this.locationPathField.setText(TextProcessor.process((String)ProjectLocationSection.this.getDefaultPathDisplayString()));
                }
                ProjectLocationSection.this.setUserAreaEnabled(!useDefaults);
                ProjectLocationSection.this.refreshLocation();
            }
        });
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectLocationSection.this.refreshLocation();
            }
        });
        this.setUserAreaEnabled(!defaultEnabled);
        this.refreshLocation();
    }

    private String getDefaultPathDisplayString() {
        String projectName = this.getProjectName();
        return ProjectLocationSection.getDefaultProjectLocation(projectName);
    }

    public static String getDefaultProjectLocation(String projectName) {
        if (projectName != null) {
            return Platform.getLocation().append(projectName).toOSString();
        }
        return Platform.getLocation().toOSString();
    }

    private String getProjectName() {
        return this.projectName.getValue();
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText("Location");
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(80, -1).applyTo((Control)this.locationLabel);
        this.locationPathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectLocationSection.this.handleLocationBrowseButtonPressed();
            }
        });
        if (defaultEnabled) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else {
            this.locationPathField.setText("");
        }
        this.projectName.addListener(new ValueListener<String>(){

            @Override
            public void gotValue(LiveExpression<String> exp, String newProjectName) {
                if (ProjectLocationSection.this.isDefault()) {
                    ProjectLocationSection.this.locationPathField.setText(TextProcessor.process((String)ProjectLocationSection.this.getDefaultPathDisplayString()));
                }
            }
        });
    }

    private void handleLocationBrowseButtonPressed() {
        String value;
        File dir;
        String selectedDirectory = null;
        String dirName = this.getPathFromLocationField();
        if (dirName != null && !dirName.equals("") && !(dir = new File(dirName)).exists()) {
            dirName = "";
        }
        if ((dirName == null || dirName.equals("")) && (value = this.getDialogSettings().get(SAVED_LOCATION_ATTR)) != null) {
            dirName = value;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell(), 0x10000000);
        dialog.setMessage("Select the location directory");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.updateLocationField(selectedDirectory);
            this.getDialogSettings().put(SAVED_LOCATION_ATTR, selectedDirectory);
        }
    }

    private void updateLocationField(String selectedPath) {
        this.locationPathField.setText(TextProcessor.process((String)selectedPath));
    }

    private String getPathFromLocationField() {
        URI fieldURI;
        try {
            fieldURI = new URI(this.locationPathField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        String path = fieldURI.getPath();
        return path != null ? path : this.locationPathField.getText();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings ideDialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings result = ideDialogSettings.getSection(this.getClass().getName());
        if (result == null) {
            result = ideDialogSettings.addNewSection(this.getClass().getName());
        }
        return result;
    }
}

