/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PrefsPageSection;

public abstract class PreferencePageWithSections
extends PreferencePage
implements IWorkbenchPreferencePage,
ValueListener<ValidationResult>,
IPageWithSections {
    private List<PrefsPageSection> sections = null;

    public void init(IWorkbench workbench) {
    }

    protected abstract List<PrefsPageSection> createSections();

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        page.setLayout((Layout)layout);
        CompositeValidator validator = new CompositeValidator();
        for (PrefsPageSection section : this.getSections()) {
            section.createContents(page);
            validator.addChild(section.getValidator());
        }
        validator.addListener(this);
        return page;
    }

    public boolean performOk() {
        for (PrefsPageSection section : this.getSections()) {
            boolean ok = section.performOK();
            if (ok) continue;
            return false;
        }
        return true;
    }

    private synchronized List<PrefsPageSection> getSections() {
        if (this.sections == null) {
            this.sections = this.createSections();
        }
        return this.sections;
    }

    protected void performDefaults() {
        super.performDefaults();
        for (PrefsPageSection section : this.getSections()) {
            section.performDefaults();
        }
    }

    @Override
    public void gotValue(LiveExpression<ValidationResult> exp, ValidationResult status) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!status.isOk()) {
            if (status.status == 4) {
                this.setErrorMessage(status.msg);
            } else if (status.status == 2) {
                this.setMessage(status.msg, 2);
            } else if (status.status == 1) {
                this.setMessage(status.msg, 1);
            } else {
                this.setMessage(status.msg, 0);
            }
        }
    }
}

