/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Key;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployKeyService
extends GitHubService {
    public DeployKeyService() {
    }

    public DeployKeyService(GitHubClient client) {
        super(client);
    }

    public List<Key> getKeys(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/keys");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Key>>(){}.getType());
        return this.getAll(request);
    }

    public Key getKey(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Key.class));
        return (Key)this.client.get(request).getBody();
    }

    public Key createKey(IRepositoryIdProvider repository, Key key) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/keys");
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public Key editKey(IRepositoryIdProvider repository, Key key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(key.getId());
        return (Key)this.client.post(uri.toString(), key, (Type)((Object)Key.class));
    }

    public void deleteKey(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/keys");
        uri.append('/').append(id);
        this.client.delete(uri.toString());
    }
}

