/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.HttpUtils;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.ResourceUtils;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.ServletUtil;

public class WorkspaceFileServlet
extends HttpServlet {
    String rootFolderLocation;
    private static final long serialVersionUID = 163695311668462503L;

    public WorkspaceFileServlet(String rootFolderLocation) {
        this.rootFolderLocation = rootFolderLocation;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = response;
        String requestURI = request.getRequestURI();
        if (requestURI == null) {
            httpServletResponse.setStatus(400);
        } else {
            IResource resource = ResourceUtils.retrieveResource(String.valueOf(this.rootFolderLocation) + requestURI);
            if (resource != null && resource.getType() == 1) {
                try {
                    IFile workspaceFile = (IFile)resource;
                    InputStream inputStream = workspaceFile.getContents();
                    byte[] content = ServletUtil.InputStreamToByteArray(inputStream);
                    httpServletResponse.getOutputStream().write(content);
                    httpServletResponse.setStatus(200);
                    Charset charset = HttpUtils.getContentCharSet(request.getHeader("accept"), workspaceFile.getCharset());
                    String guessedContentType = URLConnection.guessContentTypeFromName(resource.getName());
                    if (guessedContentType != null && !guessedContentType.contains("charset")) {
                        guessedContentType = guessedContentType.concat("; charset=").concat(charset.name());
                    }
                    httpServletResponse.setContentType(guessedContentType);
                }
                catch (CoreException e) {
                    Activator.logError((String)e.getMessage(), (Throwable)e);
                    response.sendError(500);
                }
            } else if (resource != null && resource.getType() == 2) {
                response.sendError(403);
            } else {
                response.sendError(404);
            }
        }
    }
}

