/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFile;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFileStorage;

public class HostFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 877976028427058251L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = this.getFileName(request);
        TempFile tempFile = TempFileStorage.getTempFileStorage().get(fileName);
        if (tempFile != null) {
            File hostedFile = tempFile.getFile();
            String mimeType = tempFile.getMimeType();
            this.sendFile(response, hostedFile, mimeType);
        } else {
            response.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getFileName(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String fileName = pathInfo.substring(1, pathInfo.length());
        return fileName;
    }

    private void sendFile(HttpServletResponse response, File hostedFile, String mimeType) throws IOException {
        int length;
        response.setContentType(mimeType);
        ServletOutputStream out = response.getOutputStream();
        FileInputStream in = new FileInputStream(hostedFile);
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        in.close();
        out.flush();
    }
}

