/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFile;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.TempFileStorage;

public class FormatDataServlet
extends HttpServlet {
    private static final long serialVersionUID = -4120900565146871118L;
    private static final String TEMP_FILE_URL = "tempFileUrl";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CODECS = "codecs";
    private static final String BITRATE = "bitrate";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String DURATION = "duration";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String tempFileUrl = request.getParameter(TEMP_FILE_URL);
        String tempFileName = null;
        TempFile tempFile = null;
        File file = null;
        Image image = null;
        Rectangle imageData = null;
        if (tempFileUrl != null) {
            tempFileName = this.getTempFileName(tempFileUrl);
        }
        if (tempFileName != null) {
            tempFile = TempFileStorage.getTempFileStorage().get(tempFileName);
        }
        if (tempFile != null) {
            file = tempFile.getFile();
        }
        if (file != null && file.exists()) {
            image = new Image(null, file.getAbsolutePath());
        }
        if (image != null) {
            imageData = image.getBounds();
            image.dispose();
        }
        if (imageData != null) {
            String height = Integer.toString(imageData.height);
            String width = Integer.toString(imageData.width);
            String json = this.generateJSON(height, width);
            this.sendResponse(response, json);
        } else {
            response.sendError(404);
        }
    }

    private void sendResponse(HttpServletResponse response, String json) throws IOException {
        response.setContentType(APPLICATION_JSON);
        PrintWriter out = response.getWriter();
        out.print(json);
    }

    private String getTempFileName(String tempFileUrl) {
        String tempFileName = null;
        try {
            URI uri = new URI(tempFileUrl);
            String path = uri.getPath();
            tempFileName = path.substring(path.lastIndexOf(47) + 1);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return tempFileName;
    }

    private String generateJSON(String height, String width) {
        String json = "{\"codecs\": \"null\", \"bitrate\": \"0\", \"height\": \"" + height + "\", " + "\"" + WIDTH + "\"" + ": \"" + width + "\", " + "\"" + DURATION + "\"" + ": \"0\"" + "}";
        return json;
    }
}

