/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.tools.vpe.browsersim.eclipse.Activator;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.Plugin;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.PluginIdCache;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.PluginJsException;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.CordovaFileUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.CordovaPluginXmlUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.ServletUtil;

public class CordovaPluginJsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private File pluginDir;

    public CordovaPluginJsServlet(File pluginDir) {
        this.pluginDir = pluginDir;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String ifNoneMatchValue = req.getHeader("If-None-Match");
        String eTag = ServletUtil.generateEtag(this.pluginDir);
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        if (ifNoneMatchValue != null && ifNoneMatchValue.equals(eTag)) {
            resp.setHeader("Etag", eTag);
            resp.setStatus(304);
        } else {
            try {
                List<File> pluginXmlFiles = CordovaFileUtil.getPluginXmlFiles(this.pluginDir);
                List<Plugin> plugins = CordovaPluginXmlUtil.getPluginsfromFiles(pluginXmlFiles, "android");
                PluginIdCache.update(plugins);
                String content = CordovaFileUtil.generateCordovaPluginsJsContent(plugins);
                if (content == null) {
                    content = CordovaFileUtil.getDefaultCordovaPluginJsContent();
                }
                resp.setStatus(200);
                resp.setContentType("application/javascript");
                resp.setHeader("Etag", eTag);
                resp.getWriter().write(content);
            }
            catch (PluginJsException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
                resp.sendError(500);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

