/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.server.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.tools.vpe.cordovasim.eclipse.Activator;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.CordovaFileUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.ConfigServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.CordovaJsServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.CordovaPluginJsServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.CrossOriginProxyServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.FormatDataServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.HostFileServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.NotCachingResourceHandler;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.PluginServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.StaticResponseServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.UploadFileServlet;
import org.jboss.tools.vpe.cordovasim.eclipse.servlet.internal.WorkspaceFileServlet;
import org.osgi.framework.Bundle;

public class ServerCreator {
    public static Server createServer(IProject project, IContainer resourceBase, String cordovaEngineLocation, Integer port) {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setReuseAddress(false);
        connector.setSoLingerTime(0);
        port = port != null ? port : 0;
        connector.setPort(port.intValue());
        connector.setHost("localhost");
        server.addConnector((Connector)connector);
        ServletHolder userAgentServletHolder = new ServletHolder((Servlet)new StaticResponseServlet("OK"));
        ServletHandler userAgentServletHandler = new ServletHandler();
        userAgentServletHandler.addServletWithMapping(userAgentServletHolder, "/ripple/user-agent");
        ServletHolder proxyServletHolder = new ServletHolder((Servlet)new CrossOriginProxyServlet("tinyhippos_rurl"));
        proxyServletHolder.setAsyncSupported(true);
        ServletHandler proxyServletHandler = new ServletHandler();
        proxyServletHandler.addServletWithMapping(proxyServletHolder, "/ripple/xhr_proxy");
        ServletContextHandler fileUploadContextHandler = new ServletContextHandler(1);
        ServletHolder uploadFileServletHolder = new ServletHolder((Servlet)new UploadFileServlet());
        uploadFileServletHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(null, 0x100000L, 0x100000L, 262144));
        fileUploadContextHandler.addServlet(uploadFileServletHolder, "/ripple/fileUpload");
        ServletHolder hostFileServletHolder = new ServletHolder((Servlet)new HostFileServlet());
        ServletHandler hostFileServletHandler = new ServletHandler();
        hostFileServletHandler.addServletWithMapping(hostFileServletHolder, "/temp-photo/*");
        ServletHolder formatDataServletHolder = new ServletHolder((Servlet)new FormatDataServlet());
        ServletHandler formatDataServletHandler = new ServletHandler();
        formatDataServletHandler.addServletWithMapping(formatDataServletHolder, "/ripple/formatData");
        ResourceHandler rippleResourceHandler = new ResourceHandler();
        rippleResourceHandler.setDirectoriesListed(true);
        rippleResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        String ripplePath = ServerCreator.getRippleResoursePath("ripple");
        rippleResourceHandler.setResourceBase(ripplePath);
        ContextHandler rippleContextHandler = new ContextHandler("/ripple/assets");
        rippleContextHandler.setHandler((Handler)rippleResourceHandler);
        NotCachingResourceHandler cordovaResourceHandler = new NotCachingResourceHandler();
        String cordovaPath = ServerCreator.getRippleResoursePath("ripple/cordova");
        cordovaResourceHandler.setResourceBase(cordovaPath);
        ContextHandler cordovaContextHandler = new ContextHandler("/ripple/cordova");
        cordovaContextHandler.setHandler((Handler)cordovaResourceHandler);
        String resourseLocation = resourceBase.getRawLocation().makeAbsolute().toOSString();
        NotCachingResourceHandler wwwResourceHandler = new NotCachingResourceHandler();
        wwwResourceHandler.setDirectoriesListed(true);
        wwwResourceHandler.setResourceBase(resourseLocation);
        ContextHandler wwwContextHandler = new ContextHandler("/");
        wwwContextHandler.setHandler((Handler)wwwResourceHandler);
        String workspaceResoureLocation = "/" + project.getName() + "/" + resourceBase.getProjectRelativePath().toOSString();
        ServletHolder workspaceServletHolder = new ServletHolder((Servlet)new WorkspaceFileServlet(workspaceResoureLocation));
        ServletHandler workspaceServletHandler = new ServletHandler();
        workspaceServletHandler.addServletWithMapping(workspaceServletHolder, "/");
        ServletHolder cordovaJsServletHolder = new ServletHolder((Servlet)new CordovaJsServlet(cordovaEngineLocation));
        ServletHandler cordovaJsServetHandler = new ServletHandler();
        cordovaJsServetHandler.addServletWithMapping(cordovaJsServletHolder, "/cordova.js");
        ServletHolder configHolder = new ServletHolder((Servlet)new ConfigServlet(project));
        ServletHandler configHandler = new ServletHandler();
        configHandler.addServletWithMapping(configHolder, "/config.xml");
        File pluginDir = CordovaFileUtil.getPluginDir(resourseLocation);
        ServletHolder cordovaPluginJsServletHolder = new ServletHolder((Servlet)new CordovaPluginJsServlet(pluginDir));
        ServletHandler cordovaPluginJsServetHandler = new ServletHandler();
        cordovaPluginJsServetHandler.addServletWithMapping(cordovaPluginJsServletHolder, "/cordova_plugins.js");
        ServletHolder pluginServletHolder = new ServletHolder((Servlet)new PluginServlet(pluginDir));
        ServletHandler pluginServletHandler = new ServletHandler();
        pluginServletHandler.addServletWithMapping(pluginServletHolder, "/plugins/*");
        RewriteHandler rippleRewriteHandler = new RewriteHandler();
        rippleRewriteHandler.setRewriteRequestURI(true);
        rippleRewriteHandler.setRewritePathInfo(true);
        rippleRewriteHandler.setHandler((Handler)rippleContextHandler);
        rippleRewriteHandler.addRule(new Rule(){

            public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
                if (request.getParameter("enableripple") != null) {
                    return "/ripple/assets/index.html";
                }
                return null;
            }
        });
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{userAgentServletHandler, rippleRewriteHandler, wwwResourceHandler, cordovaJsServetHandler, configHandler, cordovaPluginJsServetHandler, cordovaContextHandler, pluginServletHandler, proxyServletHandler, fileUploadContextHandler, hostFileServletHandler, formatDataServletHandler, workspaceServletHandler, new DefaultHandler()});
        server.setHandler((Handler)handlers);
        return server;
    }

    private static String getRippleResoursePath(String ripplePath) {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.vpe.cordovasim.ripple");
        URL fileURL = bundle.getEntry(ripplePath);
        try {
            URL resolvedFileURL = FileLocator.toFileURL((URL)fileURL);
            URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            File file = new File(resolvedURI);
            if (file != null && file.exists()) {
                ripplePath = file.getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return ripplePath;
    }
}

