/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.launch.internal;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cordavasim.eclipse.callbacks.CordovaSimRestartCallback;
import org.jboss.tools.cordavasim.eclipse.callbacks.StopServerCallback;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.OpenFileCallback;
import org.jboss.tools.vpe.browsersim.eclipse.callbacks.ViewSourceCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.BrowserSimLauncher;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessCallback;
import org.jboss.tools.vpe.browsersim.eclipse.launcher.ExternalProcessLauncher;
import org.jboss.tools.vpe.browsersim.ui.ExceptionNotifier;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.Activator;
import org.jboss.tools.vpe.cordovasim.eclipse.internal.util.ServerUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.launch.internal.CordovaSimLaunchParametersUtil;
import org.jboss.tools.vpe.cordovasim.eclipse.launch.internal.Messages;
import org.jboss.tools.vpe.cordovasim.eclipse.server.internal.ServerCreator;
import org.jboss.tools.vpe.cordovasim.eclipse.server.internal.ServerStorage;

public class CordovaSimLauncher {
    public static final String CORDOVASIM_CLASS_NAME = "org.jboss.tools.vpe.cordovasim.CordovaSimRunner";
    private static final List<ExternalProcessCallback> CORDOVASIM_CALLBACKS = Arrays.asList(new ViewSourceCallback(), new OpenFileCallback(), new CordovaSimRestartCallback(), new StopServerCallback());
    private static final List<String> RESOURCES_BUNDLES = BrowserSimLauncher.RESOURCES_BUNDLES;
    private static final String NOT_STANDALONE = "-not-standalone";

    public static void launchCordovaSim(String projectString, String rootFolderString, String startPageString, Integer port) {
        block11: {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add(NOT_STANDALONE);
            IContainer rootFolder = null;
            IProject project = null;
            String cordovaEngineLocation = null;
            String cordovaVersion = null;
            if (projectString != null) {
                project = CordovaSimLaunchParametersUtil.getProject(projectString);
                if (project != null) {
                    cordovaEngineLocation = CordovaSimLaunchParametersUtil.getCordovaEngineLocation(project);
                    cordovaVersion = CordovaSimLaunchParametersUtil.getCordovaVersion(project);
                }
                rootFolder = rootFolderString != null ? CordovaSimLaunchParametersUtil.getRootFolder(project, rootFolderString) : CordovaSimLaunchParametersUtil.getDefaultRootFolder(project);
            }
            String actualStartPageString = null;
            if (startPageString != null) {
                actualStartPageString = startPageString;
            } else {
                IResource startPage = CordovaSimLaunchParametersUtil.getDefaultStartPage(project, rootFolder);
                IPath startPagePath = CordovaSimLaunchParametersUtil.getRelativePath(rootFolder, startPage);
                if (startPagePath != null) {
                    String startPageFromConfigXml = CordovaSimLaunchParametersUtil.getDefaultStartPageFromConfigXml(project);
                    String startPageParameters = CordovaSimLaunchParametersUtil.getStartPageParameters(startPageFromConfigXml);
                    actualStartPageString = startPageParameters != null ? String.valueOf(startPagePath.toString()) + startPageParameters : startPagePath.toString();
                }
            }
            if (rootFolder != null && actualStartPageString != null) {
                try {
                    if (!ServerStorage.getStorage().containsKey(port) && ServerUtil.isPortAvailable(port)) {
                        Server server = ServerCreator.createServer(project, rootFolder, cordovaEngineLocation, port);
                        server.start();
                        Connector connector = server.getConnectors()[0];
                        port = connector.getLocalPort();
                        ServerStorage.getStorage().put(port, server);
                        parameters.add(rootFolder.getRawLocation().makeAbsolute().toString());
                        parameters.add("http://localhost:" + port + "/" + actualStartPageString);
                        if (cordovaVersion != null) {
                            parameters.add("-version");
                            parameters.add(cordovaVersion);
                        }
                        CordovaSimLauncher.launchCordovaSim(parameters);
                        break block11;
                    }
                    CordovaSimLauncher.showPortInUseMessage(port);
                }
                catch (Exception e) {
                    Activator.logError(e.getMessage(), e);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell parentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        if (parentShell == null) {
                            parentShell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
                        }
                        MessageDialog.openError((Shell)parentShell, (String)Messages.CordovaSimLauncher_CANNOT_RUN_CORDOVASIM, (String)Messages.CordovaSimLauncher_CANNOT_FIND_ROOT_FOLDER);
                    }
                });
            }
        }
    }

    public static List<String> getBundles() {
        List bundles = BrowserSimLauncher.getBundles();
        bundles.addAll(Arrays.asList("org.jboss.tools.vpe.cordovasim", "org.jboss.tools.vpe.cordovasim.ripple", "org.jboss.tools.vpe.browsersim.debugger", "org.eclipse.jetty.continuation", "org.eclipse.jetty.continuation", "org.eclipse.jetty.http", "org.eclipse.jetty.io", "org.eclipse.jetty.security", "org.eclipse.jetty.server", "org.eclipse.jetty.servlet", "org.eclipse.jetty.util", "org.eclipse.jetty.client", "org.eclipse.jetty.servlets", "org.eclipse.jetty.rewrite", "javax.servlet"));
        return bundles;
    }

    public static void launchCordovaSim(List<String> parameters) {
        Activator.getDefault().countLaunchEvent();
        IVMInstall jvm = BrowserSimLauncher.getSelectedVM();
        if (jvm == null) {
            ExternalProcessLauncher.showErrorDialog((String)Messages.CordovaSimLauncher_CORDOVASIM);
        } else {
            String jvmPath = jvm.getInstallLocation().getAbsolutePath();
            String jrePath = String.valueOf(jvm.getInstallLocation().getAbsolutePath()) + File.separator + "jre";
            List<String> bundles = CordovaSimLauncher.getBundles();
            if (!ExternalProcessLauncher.isGTK2() || !BrowserSimUtil.isJavaFxAvailable((String)jvmPath) && !BrowserSimUtil.isJavaFxAvailable((String)jrePath)) {
                bundles.add("org.jboss.tools.vpe.browsersim.javafx.mock");
            }
            ExternalProcessLauncher.launchAsExternalProcess(bundles, RESOURCES_BUNDLES, CORDOVASIM_CALLBACKS, (String)CORDOVASIM_CLASS_NAME, parameters, (String)Messages.CordovaSimLauncher_CORDOVASIM, (IVMInstall)jvm);
        }
    }

    private static void showPortInUseMessage(final Integer port) throws Exception {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = new Shell(display);
                String message = MessageFormat.format(Messages.ExceptionNotifier_PORT_IN_USE, port);
                ExceptionNotifier.showErrorMessage((Shell)shell, (String)message);
                shell.dispose();
            }
        });
    }
}

