/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.Plugin;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.PluginJsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CordovaPluginXmlUtil {
    public static final String PLATFORM_ANDROID = "android";
    public static final String PLATFORM_IOS = "ios";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SRC = "src";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String PLUGINS_DIR = "plugins";
    private static final String TAG_CLOBBERS = "clobbers";
    private static final String TAG_JS_MODULE = "js-module";
    private static final String TAG_MERGES = "merges";
    private static final String TAG_PLATFORM = "platform";

    public static List<Plugin> getPluginsFromDocument(Document document, String platformName) {
        if (document != null && platformName != null) {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            String pluginXmlId = CordovaPluginXmlUtil.getPluginXmlId(document);
            List<Element> suitableJsModules = CordovaPluginXmlUtil.getJsModulesForSpecificPlatform(document, platformName);
            for (Element jsModuleElement : suitableJsModules) {
                Plugin plugin = CordovaPluginXmlUtil.createPlugin(jsModuleElement, pluginXmlId);
                if (plugin == null) continue;
                plugins.add(plugin);
            }
            return plugins;
        }
        return null;
    }

    public static List<Plugin> getPluginsfromFiles(List<File> pluginXmlFiles, String platformName) throws PluginJsException {
        if (pluginXmlFiles != null && !pluginXmlFiles.isEmpty() && platformName != null) {
            ArrayList<Plugin> allPlugins = new ArrayList<Plugin>();
            for (File file : pluginXmlFiles) {
                try {
                    DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = dBuilder.parse(file);
                    doc.getDocumentElement().normalize();
                    List<Plugin> pluginsFromDocument = CordovaPluginXmlUtil.getPluginsFromDocument(doc, platformName);
                    allPlugins.addAll(pluginsFromDocument);
                }
                catch (ParserConfigurationException e) {
                    throw new PluginJsException(e);
                }
                catch (IOException e) {
                    throw new PluginJsException(e);
                }
                catch (SAXException e) {
                    throw new PluginJsException(e);
                }
            }
            return allPlugins;
        }
        return null;
    }

    private static Plugin createPlugin(Element jsModuleElement, String pluginXmlId) {
        Plugin plugin = null;
        String moduleName = jsModuleElement.getAttribute(ATTRIBUTE_NAME);
        String src = jsModuleElement.getAttribute(ATTRIBUTE_SRC);
        if (moduleName != null && src != null) {
            List<Element> mergesList = CordovaPluginXmlUtil.getChildElementsByName(jsModuleElement, TAG_MERGES);
            List<Element> clobbersList = CordovaPluginXmlUtil.getChildElementsByName(jsModuleElement, TAG_CLOBBERS);
            List<String> clobbers = CordovaPluginXmlUtil.getMappers(clobbersList);
            List<String> merges = CordovaPluginXmlUtil.getMappers(mergesList);
            String pluginId = String.valueOf(pluginXmlId) + "." + moduleName;
            String file = "plugins/" + pluginXmlId + "/" + src;
            if (clobbers.size() > 0 || merges.size() > 0) {
                plugin = new Plugin(file, pluginId, clobbers, merges);
            }
        }
        return plugin;
    }

    private static List<Element> getJsModulesForSpecificPlatform(Document doc, String platformName) {
        ArrayList<Element> suitableJsModules = new ArrayList<Element>();
        Element documentElement = doc.getDocumentElement();
        NodeList childNodes = documentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (CordovaPluginXmlUtil.isJsModuleElement(element)) {
                    suitableJsModules.add(element);
                } else if (CordovaPluginXmlUtil.isPlatformElement(element) && element.getAttribute(ATTRIBUTE_NAME) != null && element.getAttribute(ATTRIBUTE_NAME).equals(platformName)) {
                    List<Element> androidJsModules = CordovaPluginXmlUtil.getChildElementsByName(element, TAG_JS_MODULE);
                    suitableJsModules.addAll(androidJsModules);
                }
            }
            ++i;
        }
        return suitableJsModules;
    }

    private static List<String> getMappers(List<Element> mappersList) {
        ArrayList<String> mappers = new ArrayList<String>();
        int i = 0;
        while (i < mappersList.size()) {
            Element mapperElement = mappersList.get(i);
            String mapper = mapperElement.getAttribute(ATTRIBUTE_TARGET);
            mappers.add(mapper);
            ++i;
        }
        return mappers;
    }

    private static List<Element> getChildElementsByName(Element parentElement, String childElementName) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList childNodes = parentElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element childElement;
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1 && (childElement = (Element)node).getNodeName().equals(childElementName)) {
                elementList.add(childElement);
            }
            ++i;
        }
        return elementList;
    }

    private static boolean isJsModuleElement(Element element) {
        String elementName = element.getNodeName();
        return elementName.equals(TAG_JS_MODULE);
    }

    private static boolean isPlatformElement(Element element) {
        String elementName = element.getNodeName();
        return elementName.equals(TAG_PLATFORM);
    }

    private static String getPluginXmlId(Document doc) {
        Element element = doc.getDocumentElement();
        return element.getAttribute(ATTRIBUTE_ID);
    }
}

