/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.m2e.egit.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.MavenImportWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.sonatype.m2e.egit.internal.WorkingDirectory;

public class ImportMavenProjects
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.selection != null) {
            Iterator it = this.selection.iterator();
            while (it.hasNext()) {
                locations.add(((WorkingDirectory)it.next()).getPath());
            }
        }
        MavenImportWizard wizard = new MavenImportWizard(new ProjectImportConfiguration(), locations);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    private Shell getShell() {
        Shell shell = null;
        if (this.targetPart != null) {
            shell = this.targetPart.getSite().getShell();
        }
        if (shell != null) {
            return shell;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getShell();
    }
}

