/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTree;
import org.tigris.subversion.subclipse.ui.wizards.IClosableWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;

public class SvnWizardLockPage
extends SvnWizardDialogPage {
    private CommitCommentArea commitCommentArea;
    private Button stealButton;
    private String comment;
    private boolean stealLock;
    private IResource[] files;
    private CommentProperties commentProperties;
    private ResourceSelectionTree resourceSelectionTree;

    public SvnWizardLockPage(IResource[] files) {
        super("LockDialog", Policy.bind("LockDialog.title"));
        this.files = files;
        if (files.length > 0) {
            try {
                this.commentProperties = CommentProperties.getCommentProperties(files[0]);
                this.commentProperties.setMinimumLogMessageSize(this.commentProperties.getMinimumLockMessageSize());
            }
            catch (SVNException sVNException) {}
            if (this.commentProperties != null) {
                this.commentProperties.setLogTemplate(null);
            }
        }
        this.commitCommentArea = new CommitCommentArea(null, null, this.commentProperties);
        this.commitCommentArea.setShowLabel(false);
        if (this.commentProperties != null && this.commentProperties.getMinimumLockMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardLockPage.this.setPageComplete(SvnWizardLockPage.this.canFinish());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested" && SvnWizardLockPage.this.canFinish()) {
                    IClosableWizard wizard = (IClosableWizard)SvnWizardLockPage.this.getWizard();
                    wizard.finishAndClose();
                }
            }
        });
    }

    public void createControls(Composite composite) {
        SashForm sashForm = new SashForm(composite, 512);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        sashForm.setLayout((Layout)gridLayout);
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite cTop = new Composite((Composite)sashForm, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        cTop.setLayout((Layout)topLayout);
        cTop.setLayoutData((Object)new GridData(1808));
        Composite cBottom1 = new Composite((Composite)sashForm, 0);
        GridLayout bottom1Layout = new GridLayout();
        bottom1Layout.marginHeight = 0;
        bottom1Layout.marginWidth = 0;
        cBottom1.setLayout((Layout)bottom1Layout);
        cBottom1.setLayoutData((Object)new GridData(1808));
        Composite cBottom2 = new Composite(cBottom1, 0);
        GridLayout bottom2Layout = new GridLayout();
        bottom2Layout.marginHeight = 0;
        bottom2Layout.marginWidth = 0;
        cBottom2.setLayout((Layout)bottom2Layout);
        cBottom2.setLayoutData((Object)new GridData(1808));
        this.commitCommentArea.createArea(cTop);
        this.addResourcesArea(cBottom2);
        this.setPageComplete(this.canFinish());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.lock_dialog_context");
    }

    private void addResourcesArea(Composite composite) {
        ResourceSelectionTree.IToolbarControlCreator toolbarControlCreator = new ResourceSelectionTree.IToolbarControlCreator(){

            public void createToolbarControls(ToolBarManager toolbarManager) {
                toolbarManager.add((IContributionItem)new ControlContribution("stealLock"){

                    protected Control createControl(Composite parent) {
                        SvnWizardLockPage.this.stealButton = new Button(parent, 32);
                        SvnWizardLockPage.this.stealButton.setText(Policy.bind("LockDialog.stealLock"));
                        return SvnWizardLockPage.this.stealButton;
                    }
                });
            }

            public int getControlCount() {
                return 1;
            }
        };
        this.resourceSelectionTree = new ResourceSelectionTree(composite, 0, "These files will be locked:", this.files, new HashMap(), null, false, toolbarControlCreator, null);
        this.resourceSelectionTree.setShowRemoveFromViewAction(false);
    }

    public String getWindowTitle() {
        return Policy.bind("LockDialog.title");
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.stealLock = this.stealButton.getSelection();
        this.comment = this.commitCommentArea.getComment(true);
        return true;
    }

    public void saveSettings() {
    }

    public void setMessage() {
        this.setMessage(Policy.bind("LockDialog.message"));
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isStealLock() {
        return this.stealLock;
    }

    private boolean canFinish() {
        if (this.commentProperties == null) {
            return true;
        }
        return this.commitCommentArea.getCommentLength() >= this.commentProperties.getMinimumLogMessageSize();
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }
}

