/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ClosableWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;

public class SvnWizardDialog
extends ClosableWizardDialog {
    public boolean yesNo;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private SvnWizardDialogPage wizardPage;

    public SvnWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        SvnWizard wizard = (SvnWizard)this.getWizard();
        this.wizardPage = wizard.getSvnWizardDialogPage();
    }

    public SvnWizardDialog(Shell parentShell, IWizard newWizard, boolean yesNo) {
        this(parentShell, newWizard);
        this.yesNo = yesNo;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button cancelButton;
        this.wizardPage.createButtonsForButtonBar(parent, this);
        super.createButtonsForButtonBar(parent);
        if (this.yesNo && (cancelButton = this.getButton(1)) != null) {
            cancelButton.setText("No");
        }
    }

    public Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        String customLabel = id == 16 ? (this.yesNo ? "Yes" : "OK") : label;
        return super.createButton(parent, id, customLabel, defaultButton);
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    public void finishPressed() {
        this.saveLocation();
        super.finishPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt(String.valueOf(this.wizardPage.getName()) + ".location.x");
            int y = this.settings.getInt(String.valueOf(this.wizardPage.getName()) + ".location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt(String.valueOf(this.wizardPage.getName()) + ".size.x");
            int y = this.settings.getInt(String.valueOf(this.wizardPage.getName()) + ".size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    protected void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put(String.valueOf(this.wizardPage.getName()) + ".location.x", x);
        this.settings.put(String.valueOf(this.wizardPage.getName()) + ".location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put(String.valueOf(this.wizardPage.getName()) + ".size.x", x);
        this.settings.put(String.valueOf(this.wizardPage.getName()) + ".size.y", y);
        this.wizardPage.saveSettings();
    }
}

