/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;
import org.tigris.subversion.subclipse.ui.compare.PropertyComparePropertyNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class PropertyCompareRemoteResourceNode
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor,
IPropertyProvider {
    private ISVNRemoteResource remoteResource;
    private SVNRevision pegRevision;
    private boolean recursive;
    private ISVNProperty[] properties;
    private Object[] children;

    public PropertyCompareRemoteResourceNode(ISVNRemoteResource remoteResource, SVNRevision pegRevision, boolean recursive, ISVNProperty[] properties) {
        this.remoteResource = remoteResource;
        this.pegRevision = pegRevision;
        this.recursive = recursive;
        this.properties = properties;
    }

    public void getProperties(boolean recursive) {
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = this.remoteResource.getRepository().getSVNClient();
                this.properties = svnClient.getProperties(this.remoteResource.getUrl(), this.remoteResource.getRevision(), this.pegRevision, recursive);
            }
            catch (Exception e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
        finally {
            this.remoteResource.getRepository().returnSVNClient(svnClient);
        }
    }

    public String getLabel() {
        return String.valueOf(Policy.bind("PropertyCompareRemoteResourceNode.0")) + this.remoteResource.getName().replaceAll("%20", " ") + "@" + this.remoteResource.getRevision();
    }

    public boolean isEditable() {
        return false;
    }

    public InputStream getContents() throws CoreException {
        return null;
    }

    public String getName() {
        return this.remoteResource.getName();
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.remoteResource);
    }

    public String getType() {
        return "FOLDER";
    }

    public Object[] getChildren() {
        if (this.children == null) {
            ArrayList<Object> childList = new ArrayList<Object>();
            ISVNProperty[] iSVNPropertyArray = this.properties;
            int n = 0;
            int n2 = iSVNPropertyArray.length;
            while (n < n2) {
                ISVNProperty property = iSVNPropertyArray[n];
                if (property.getUrl().toString().equals(this.remoteResource.getUrl().toString())) {
                    childList.add(new PropertyComparePropertyNode(property));
                }
                ++n;
            }
            if (this.recursive && this.remoteResource.isContainer()) {
                try {
                    ISVNRemoteResource[] childResources;
                    ISVNRemoteResource[] iSVNRemoteResourceArray = childResources = this.remoteResource.members((IProgressMonitor)new NullProgressMonitor());
                    n2 = 0;
                    int n3 = iSVNRemoteResourceArray.length;
                    while (n2 < n3) {
                        ISVNRemoteResource childResource = iSVNRemoteResourceArray[n2];
                        PropertyCompareRemoteResourceNode childNode = new PropertyCompareRemoteResourceNode(childResource, this.pegRevision, this.recursive, this.properties);
                        childList.add(childNode);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    SVNUIPlugin.log(e);
                }
            }
            this.children = new Object[childList.size()];
            childList.toArray(this.children);
        }
        return this.children;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.remoteResource;
    }

    public boolean equals(Object other) {
        if (!this.recursive) {
            return true;
        }
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

