/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards.webbrowser;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import tern.eclipse.ide.tools.core.webbrowser.EditorOptions;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIMessages;
import tern.eclipse.ide.tools.internal.ui.wizards.TernWizardPage;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.TernModuleHelper;

public class TernPluginsSelectionWizardPage
extends TernWizardPage<EditorOptions> {
    private static final String PAGE = "TernPluginsSelectionWizardPage";
    private TernModulesBlock modulesBlock;

    protected TernPluginsSelectionWizardPage() {
        super(PAGE);
        this.setTitle(TernToolsUIMessages.TernPluginsSelectionWizardPage_title);
        this.setDescription(TernToolsUIMessages.TernPluginsSelectionWizardPage_description);
    }

    @Override
    protected Composite createUI(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        IResource resource = super.getResource();
        IProject project = resource != null ? resource.getProject() : null;
        this.modulesBlock = new TernModulesBlock(project, null);
        this.modulesBlock.createControl(container);
        this.modulesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TernPluginsSelectionWizardPage.this.dialogChanged();
            }
        });
        Control control = this.modulesBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        return container;
    }

    @Override
    protected void initialize() {
        this.modulesBlock.loadModules();
    }

    @Override
    protected String validate() {
        return null;
    }

    @Override
    protected void updateModel(EditorOptions model) {
        Object[] modules = this.modulesBlock.getCheckedModules();
        ArrayList defs = new ArrayList();
        ArrayList plugins = new ArrayList();
        ITernModule module = null;
        int i = 0;
        while (i < modules.length) {
            module = (ITernModule)modules[i];
            TernModuleHelper.update(defs, plugins, (ITernModule)module);
            ++i;
        }
        model.setTernDefs(defs.toArray(ITernDef.EMPTY_DEF));
        model.setTernPlugins(plugins.toArray(ITernPlugin.EMPTY_PLUGIN));
    }
}

