/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.misc;

import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class ArrayTypeStyleQuickfix
extends AbstractASTResolution {
    protected ASTVisitor handleGetCorrectingASTVisitor(IRegion lineInfo, final int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                if (ArrayTypeStyleQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    if (this.isCStyle(node.fragments())) {
                        int dimensions = 0;
                        List fragments = node.fragments();
                        int i = 0;
                        int size = fragments.size();
                        while (i < size) {
                            VariableDeclaration decl = (VariableDeclaration)fragments.get(i);
                            if (decl.getExtraDimensions() > dimensions) {
                                dimensions = decl.getExtraDimensions();
                            }
                            decl.setExtraDimensions(0);
                            ++i;
                        }
                        ArrayType arrayType = this.createArrayType(node.getType(), dimensions);
                        node.setType((Type)arrayType);
                    } else if (this.isJavaStyle(node.getType())) {
                        int dimensions = ((ArrayType)node.getType()).getDimensions();
                        List fragments = node.fragments();
                        int i = 0;
                        int size = fragments.size();
                        while (i < size) {
                            VariableDeclaration decl = (VariableDeclaration)fragments.get(i);
                            decl.setExtraDimensions(dimensions);
                            ++i;
                        }
                        Type elementType = (Type)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)((ArrayType)node.getType()).getElementType());
                        node.setType(elementType);
                    }
                }
                return true;
            }

            public boolean visit(SingleVariableDeclaration node) {
                if (ArrayTypeStyleQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    if (this.isCStyle((VariableDeclaration)node)) {
                        node.setType((Type)this.createArrayType(node.getType(), node.getExtraDimensions()));
                        node.setExtraDimensions(0);
                    } else if (this.isJavaStyle(node.getType())) {
                        ArrayType arrayType = (ArrayType)node.getType();
                        Type elementType = (Type)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)arrayType.getElementType());
                        node.setType(elementType);
                        node.setExtraDimensions(arrayType.getDimensions());
                    }
                }
                return true;
            }

            public boolean visit(FieldDeclaration node) {
                if (ArrayTypeStyleQuickfix.this.containsPosition((ASTNode)node, markerStartOffset)) {
                    if (this.isCStyle(node.fragments())) {
                        int dimensions = 0;
                        List fragments = node.fragments();
                        int i = 0;
                        int size = fragments.size();
                        while (i < size) {
                            VariableDeclaration decl = (VariableDeclaration)fragments.get(i);
                            if (decl.getExtraDimensions() > dimensions) {
                                dimensions = decl.getExtraDimensions();
                            }
                            decl.setExtraDimensions(0);
                            ++i;
                        }
                        ArrayType arrayType = this.createArrayType(node.getType(), dimensions);
                        node.setType((Type)arrayType);
                    } else if (this.isJavaStyle(node.getType())) {
                        int dimensions = ((ArrayType)node.getType()).getDimensions();
                        List fragments = node.fragments();
                        int i = 0;
                        int size = fragments.size();
                        while (i < size) {
                            VariableDeclaration decl = (VariableDeclaration)fragments.get(i);
                            decl.setExtraDimensions(dimensions);
                            ++i;
                        }
                        Type elementType = (Type)ASTNode.copySubtree((AST)node.getAST(), (ASTNode)((ArrayType)node.getType()).getElementType());
                        node.setType(elementType);
                    }
                }
                return true;
            }

            private boolean isJavaStyle(Type type) {
                return type instanceof ArrayType;
            }

            private boolean isCStyle(VariableDeclaration decl) {
                return decl.getExtraDimensions() > 0;
            }

            private boolean isCStyle(List fragments) {
                for (VariableDeclaration decl : fragments) {
                    if (!this.isCStyle(decl)) continue;
                    return true;
                }
                return false;
            }

            private ArrayType createArrayType(Type componentType, int dimensions) {
                Type type = (Type)ASTNode.copySubtree((AST)componentType.getAST(), (ASTNode)componentType);
                ArrayType arrayType = componentType.getAST().newArrayType(type, dimensions);
                return arrayType;
            }
        };
    }

    public String getDescription() {
        return Messages.ArrayTypeStyleQuickfix_description;
    }

    public String getLabel() {
        return Messages.ArrayTypeStyleQuickfix_label;
    }

    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_CHANGE);
    }
}

