/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class BootPropertyTester
extends PropertyTester {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");

    private static void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public boolean test(Object rsrc, String property, Object[] args, Object expectedValue) {
        if (rsrc instanceof IProject && "isBootProject".equals(property)) {
            return expectedValue.equals(BootPropertyTester.isBootProject((IProject)rsrc));
        }
        if (rsrc instanceof IResource && "isBootResource".equals(property)) {
            return expectedValue.equals(BootPropertyTester.isBootResource((IResource)rsrc));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBootProject(IProject project) {
        if (project == null) return false;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IClasspathEntry[] classpath;
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) return false;
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = classpath = jp.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (BootPropertyTester.isBootJar(e)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            CorePlugin.log((Throwable)e);
        }
        return false;
    }

    public static boolean isBootResource(IResource rsrc) {
        if (rsrc == null || !rsrc.isAccessible()) {
            return false;
        }
        boolean result = BootPropertyTester.isBootProject(rsrc.getProject());
        return result;
    }

    private static boolean isBootJar(IClasspathEntry e) {
        if (e.getEntryKind() == 1) {
            IPath path = e.getPath();
            String name = path.lastSegment();
            return name.endsWith(".jar") && name.startsWith("spring-boot");
        }
        return false;
    }
}

