/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.completions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.core.runtime.Assert;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;

public class DirectedGraph {
    private MultiMap dgraph = new MultiValueMap();

    public Set getDescendants(Object node) {
        LinkedHashSet<Object> descendants = new LinkedHashSet<Object>();
        return this.getDescendants(node, descendants);
    }

    private Set<Object> getDescendants(Object node, Set<Object> descendants) {
        Assert.isLegal((boolean)descendants.isEmpty());
        this.collectDescendants(node, descendants);
        return descendants;
    }

    private void collectDescendants(Object node, Set ancestors) {
        Collection children = (Collection)this.dgraph.get(node);
        if (children != null && !children.isEmpty()) {
            for (Object parent : children) {
                boolean isNew = ancestors.add(parent);
                if (!isNew) continue;
                this.collectDescendants(parent, ancestors);
            }
        }
    }

    public Collection getSuccessors(ExternalType type) {
        return (Collection)this.dgraph.get((Object)type);
    }

    public void addEdge(Object parent, Object child) {
        this.dgraph.put(parent, child);
    }

    public Set getNonLeafNodes() {
        return this.dgraph.keySet();
    }
}

