/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtil {
    private PropertyUtil() {
    }

    public static boolean hasUnresolvedProperties(String value) throws CheckstyleException {
        if (value != null) {
            ArrayList<String> props = new ArrayList<String>();
            PropertyUtil.parsePropertyString(value, new ArrayList<String>(), props);
            return !props.isEmpty();
        }
        return false;
    }

    public static String replaceProperties(String aValue, PropertyResolver aProps) throws CheckstyleException {
        if (aValue == null) {
            return null;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        PropertyUtil.parsePropertyString(aValue, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String propertyName;
            String fragment = (String)i.next();
            if (fragment == null && (fragment = aProps.resolve(propertyName = (String)j.next())) == null) {
                throw new CheckstyleException("Property ${" + propertyName + "} has not been set");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String aValue, List<String> aFragments, List<String> aPropertyRefs) throws CheckstyleException {
        int pos;
        int prev = 0;
        while ((pos = aValue.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                aFragments.add(aValue.substring(prev, pos));
            }
            if (pos == aValue.length() - 1) {
                aFragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (aValue.charAt(pos + 1) != '{') {
                if (aValue.charAt(pos + 1) == '$') {
                    aFragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                aFragments.add(aValue.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = aValue.indexOf(125, pos);
            if (endName < 0) {
                throw new CheckstyleException("Syntax error in property: " + aValue);
            }
            String propertyName = aValue.substring(pos + 2, endName);
            aFragments.add(null);
            aPropertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < aValue.length()) {
            aFragments.add(aValue.substring(prev));
        }
    }
}

