/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyMetadata;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
implements Cloneable {
    private String mName;
    private RuleMetadata mMetaData;
    private List<ConfigProperty> mProperties = new ArrayList<ConfigProperty>();
    private String mComment;
    private String mId;
    private final Map<String, String> mCustomMessages = new HashMap<String, String>();
    private Severity mSeverityLevel = Severity.inherit;
    private Severity mLastEnabledSeverity;
    private final Map<String, String> mCustomMetaData = new HashMap<String, String>();

    public Module(RuleMetadata metaData, boolean withDefaults) {
        this.mMetaData = metaData;
        if (metaData != null) {
            List<ConfigPropertyMetadata> propMetas = metaData.getPropertyMetadata();
            int size = propMetas != null ? propMetas.size() : 0;
            int i = 0;
            while (i < size) {
                ConfigPropertyMetadata propMeta = propMetas.get(i);
                ConfigProperty property = new ConfigProperty(propMeta);
                this.getProperties().add(property);
                if (withDefaults) {
                    property.setValue(propMeta.getDefaultValue());
                }
                ++i;
            }
            if (metaData.getDefaultSeverityLevel() != null) {
                this.mSeverityLevel = metaData.getDefaultSeverityLevel();
            }
        }
    }

    public Module(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mMetaData != null ? this.mMetaData.getRuleName() : this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public Map<String, String> getCustomMessages() {
        return this.mCustomMessages;
    }

    public RuleMetadata getMetaData() {
        return this.mMetaData;
    }

    public void setMetaData(RuleMetadata metaData) {
        this.mMetaData = metaData;
    }

    public List<ConfigProperty> getProperties() {
        return this.mProperties;
    }

    public ConfigProperty getProperty(String property) {
        ConfigProperty propertyObj = null;
        int size = this.mProperties != null ? this.mProperties.size() : 0;
        int i = 0;
        while (i < size) {
            ConfigProperty tmp = this.mProperties.get(i);
            if (tmp.getName().equals(property)) {
                propertyObj = tmp;
                break;
            }
            ++i;
        }
        return propertyObj;
    }

    public String getComment() {
        return this.mComment;
    }

    public void setComment(String comment) {
        this.mComment = comment;
    }

    public Severity getSeverity() {
        if (this.mMetaData != null && this.mMetaData.hasSeverity()) {
            return this.mSeverityLevel != null ? this.mSeverityLevel : this.getMetaData().getDefaultSeverityLevel();
        }
        return null;
    }

    public Severity getLastEnabledSeverity() {
        return this.mLastEnabledSeverity;
    }

    public void setLastEnabledSeverity(Severity severity) {
        this.mLastEnabledSeverity = severity;
    }

    public void setSeverity(Severity severityLevel) {
        Severity defaultLevel = null;
        if (this.mMetaData != null && this.mMetaData.hasSeverity()) {
            defaultLevel = this.getMetaData().getDefaultSeverityLevel();
        } else if (this.mMetaData == null) {
            defaultLevel = MetadataFactory.getDefaultSeverity();
        }
        if (defaultLevel != null) {
            if (severityLevel.equals((Object)defaultLevel)) {
                this.mSeverityLevel = null;
                this.setLastEnabledSeverity(null);
            } else if (Severity.ignore.equals((Object)severityLevel)) {
                if (this.mSeverityLevel != null && !Severity.ignore.equals((Object)this.mSeverityLevel)) {
                    this.setLastEnabledSeverity(this.mSeverityLevel);
                }
                this.mSeverityLevel = severityLevel;
            } else {
                this.mSeverityLevel = severityLevel;
            }
        }
    }

    public Map<String, String> getCustomMetaData() {
        return this.mCustomMetaData;
    }

    public Module clone() {
        try {
            Module clone = (Module)super.clone();
            clone.mProperties = new ArrayList<ConfigProperty>();
            for (ConfigProperty prop : this.mProperties) {
                clone.getProperties().add(prop.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

