/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.metadata.core.AutowireAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.AutowireMethodAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireAnnotationMetadataProvider
implements IAnnotationBeanMetadataProvider {
    private static final String[] ANNOTATION_CLASSES = new String[]{Value.class.getName(), Autowired.class.getName(), "javax.inject.Inject", "javax.ejb.EJB", "javax.annotation.Resource", "javax.xml.ws.WebServiceRef"};

    public Set<IBeanMetadata> provideBeanMetadata(IBean bean, IType type, IAnnotationMetadata visitor) {
        LinkedHashSet<IBeanMetadata> beanMetaDataSet = new LinkedHashSet<IBeanMetadata>();
        try {
            String[] stringArray = ANNOTATION_CLASSES;
            int n = ANNOTATION_CLASSES.length;
            int n2 = 0;
            while (n2 < n) {
                String annotationClass = stringArray[n2];
                HashSet<IMethodMetadata> methodMetaData = new HashSet<IMethodMetadata>();
                if (visitor.hasMethodLevelAnnotations(new String[]{annotationClass})) {
                    for (Map.Entry entry : visitor.getMethodLevelAnnotations(new String[]{annotationClass}).entrySet()) {
                        methodMetaData.add((IMethodMetadata)new AutowireMethodAnnotationMetadata(((Annotation)entry.getValue()).getAnnotationClass(), ((IMethod)entry.getKey()).getHandleIdentifier(), ((Annotation)entry.getValue()).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)entry.getKey())));
                    }
                }
                if (visitor.hasFieldLevelAnnotations(new String[]{annotationClass})) {
                    for (Map.Entry entry : visitor.getFieldLevelAnnotations(new String[]{annotationClass}).entrySet()) {
                        methodMetaData.add((IMethodMetadata)new AutowireMethodAnnotationMetadata(((Annotation)entry.getValue()).getAnnotationClass(), ((IField)entry.getKey()).getHandleIdentifier(), ((Annotation)entry.getValue()).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)entry.getKey())));
                    }
                }
                if (methodMetaData.size() > 0) {
                    beanMetaDataSet.add((IBeanMetadata)new AutowireAnnotationMetadata(bean, annotationClass, (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)type), methodMetaData));
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return beanMetaDataSet;
    }
}

