/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.DeclareAnnotation;
import org.aspectj.lang.annotation.DeclareError;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.DeclareWarning;
import org.aspectj.lang.annotation.Pointcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.metadata.core.AspectAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.AspectMethodAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectAnnotationMetadataProvider
implements IAnnotationBeanMetadataProvider {
    private static final String ASPECT_ANNOTATION_CLASS = Aspect.class.getName();
    private static final String[] METHOD_ANNOTATION_CLASSES = new String[]{Before.class.getName(), After.class.getName(), AfterReturning.class.getName(), AfterThrowing.class.getName(), Around.class.getName(), DeclareParents.class.getName(), DeclareAnnotation.class.getName(), DeclareWarning.class.getName(), DeclareError.class.getName(), Pointcut.class.getName()};

    public Set<IBeanMetadata> provideBeanMetadata(IBean bean, IType type, IAnnotationMetadata visitor) {
        LinkedHashSet<IBeanMetadata> beanMetaDataSet = new LinkedHashSet<IBeanMetadata>();
        try {
            if (visitor.hasTypeLevelAnnotations(new String[]{ASPECT_ANNOTATION_CLASS})) {
                HashSet<IMethodMetadata> methodMetaData = new HashSet<IMethodMetadata>();
                for (Map.Entry entry : visitor.getMethodLevelAnnotations(METHOD_ANNOTATION_CLASSES).entrySet()) {
                    methodMetaData.add((IMethodMetadata)new AspectMethodAnnotationMetadata(((Annotation)entry.getValue()).getAnnotationClass(), ((IMethod)entry.getKey()).getHandleIdentifier(), ((Annotation)entry.getValue()).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)entry.getKey())));
                }
                beanMetaDataSet.add((IBeanMetadata)new AspectAnnotationMetadata(bean, ASPECT_ANNOTATION_CLASS, visitor.hasTypeLevelAnnotations(new String[]{ASPECT_ANNOTATION_CLASS}) ? visitor.getTypeLevelAnnotation(ASPECT_ANNOTATION_CLASS).getMembers() : null, (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)type), methodMetaData));
            }
        }
        catch (JavaModelException javaModelException) {}
        return beanMetaDataSet;
    }
}

