/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.springsource.ide.eclipse.commons.internal.ui.UiPlugin;

public final class SpringUIUtils {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Button createButton(Composite parent, String labelText, SelectionListener listener) {
        return SpringUIUtils.createButton(parent, labelText, listener, 0, true);
    }

    public static Button createButton(Composite parent, String labelText, SelectionListener listener, int indentation, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(labelText);
        button.addSelectionListener(listener);
        button.setEnabled(enabled);
        FontMetrics fontMetrics = SpringUIUtils.getFontMetrics((Control)button);
        GridData gd = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd.horizontalIndent = indentation;
        button.setLayoutData((Object)gd);
        return button;
    }

    public static Button createCheckBox(Composite parent, String labelText) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        button.setText(labelText);
        button.setLayoutData((Object)new GridData(32));
        return button;
    }

    public static Text createTextField(Composite parent, String labelText) {
        return SpringUIUtils.createTextField(parent, labelText, 0, 0, 0);
    }

    public static Text createTextField(Composite parent, String labelText, int indentation) {
        return SpringUIUtils.createTextField(parent, labelText, indentation, 0, 0);
    }

    public static Text createTextField(Composite parent, String labelText, int indentation, int textWidth) {
        return SpringUIUtils.createTextField(parent, labelText, indentation, textWidth, 0);
    }

    public static Text createTextField(Composite parent, String labelText, int indentation, int textWidth, int labelWidth) {
        Composite textArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        textArea.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        textArea.setLayoutData((Object)gd);
        Label label = new Label(textArea, 0);
        label.setText(labelText);
        label.setFont(parent.getFont());
        if (labelWidth > 0) {
            gd = new GridData(32);
            gd.widthHint = labelWidth;
            label.setLayoutData((Object)gd);
        }
        Text text = new Text(textArea, 2052);
        text.setFont(parent.getFont());
        if (textWidth > 0) {
            gd = new GridData(32);
            gd.widthHint = textWidth;
        } else {
            gd = new GridData(768);
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    public static FontMetrics getFontMetrics(Control control) {
        FontMetrics fontMetrics = null;
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(control.getFont());
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            gc.dispose();
        }
        return fontMetrics;
    }

    public static boolean showPreferenceDialog(String propertyPageId, IProject project, Map<String, Object> data) {
        IPreferenceNode[] nodes;
        IPreferenceNode targetNode = null;
        PropertyPageManager pageManager = new PropertyPageManager();
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)project);
        IPreferenceNode[] iPreferenceNodeArray = nodes = pageManager.getRootSubNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode node = iPreferenceNodeArray[n2];
            if ("org.springframework.ide.eclipse.ui.projectPropertyPage".equals(node.getId())) {
                targetNode = node;
                break;
            }
            ++n2;
        }
        if (targetNode != null) {
            return SpringUIUtils.openPreferenceNode(propertyPageId, targetNode, "Properties for " + project.getName(), project, data);
        }
        return false;
    }

    private static boolean openPreferenceNode(String propertyPageId, final IPreferenceNode targetNode, final String title, Object element, Map<String, Object> data) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PropertyDialog dialog = new PropertyDialog(UiPlugin.getActiveWorkbenchShell(), manager, (ISelection)new StructuredSelection(element));
        if (propertyPageId != null) {
            dialog.setSelectedNode(propertyPageId);
        }
        if (data != null) {
            dialog.setPageData(data);
        }
        final boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)SpringUIUtils.getStandardDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                dialog.getShell().setText(title);
                result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = UiPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static ITextEditor getTextEditor(IEditorPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        if (part instanceof IAdaptable) {
            return (ITextEditor)part.getAdapter(ITextEditor.class);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart editor, int line) {
        ITextEditor textEditor = SpringUIUtils.getTextEditor(editor);
        if (textEditor != null && line > 0) {
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return;
            }
            IDocument document = provider.getDocument((Object)input);
            try {
                IRegion lineRegion = document.getLineInformation(line - 1);
                textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException badLocationException) {}
            provider.disconnect((Object)input);
        }
    }

    public static IEditorPart openInEditor(IFile file, int line) {
        return SpringUIUtils.openInEditor(file, line, true);
    }

    public static IEditorPart openInEditor(IFile file, int line, boolean activate) {
        IEditorPart editor = null;
        IWorkbenchPage page = UiPlugin.getActiveWorkbenchPage();
        try {
            if (line > 0) {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
                ITextEditor textEditor = null;
                if (editor instanceof ITextEditor) {
                    textEditor = (ITextEditor)editor;
                } else if (editor instanceof IAdaptable) {
                    textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
                }
                if (textEditor != null) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    try {
                        int start = document.getLineOffset(line - 1);
                        textEditor.selectAndReveal(start, 0);
                        page.activate((IWorkbenchPart)editor);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", line);
                    editor = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)activate);
                    marker.delete();
                }
            } else {
                editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)activate);
            }
        }
        catch (CoreException e) {
            SpringUIUtils.openError("Open Editor Problems", e.getMessage(), e);
        }
        return editor;
    }

    public static IEditorPart openInEditor(IEditorInput input, String editorId) {
        return SpringUIUtils.openInEditor(input, editorId, true);
    }

    public static IEditorPart openInEditor(IEditorInput input, String editorId, boolean activate) {
        IWorkbenchPage page = UiPlugin.getActiveWorkbenchPage();
        try {
            return page.openEditor(input, editorId, activate);
        }
        catch (PartInitException e) {
            SpringUIUtils.openError("Open Editor Problems", e.getMessage(), (CoreException)((Object)e));
            return null;
        }
    }

    public static IEditorPart openInEditor(IJavaElement element) {
        try {
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)element);
            if (editor != null) {
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)element);
            }
            return editor;
        }
        catch (PartInitException e) {
            SpringUIUtils.openError("Open Editor Problems", e.getMessage(), (CoreException)((Object)e));
        }
        catch (JavaModelException e) {
            SpringUIUtils.openError("Open Editor Problems", e.getMessage(), (CoreException)((Object)e));
        }
        return null;
    }

    public static int getCaretOffset(ITextEditor editor) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getOffset();
        }
        return -1;
    }

    public static String getSelectedText(ITextEditor editor) {
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText().trim();
        }
        return null;
    }

    public static IProgressMonitor getStatusLineProgressMonitor() {
        IEditorPart editor;
        IWorkbenchPage wbPage = UiPlugin.getActiveWorkbenchPage();
        if (wbPage != null && (editor = wbPage.getActiveEditor()) != null) {
            IActionBars bars = editor.getEditorSite().getActionBars();
            return bars.getStatusLineManager().getProgressMonitor();
        }
        return null;
    }

    public static void openError(String title, String message, CoreException exception) {
        Shell shell = UiPlugin.getActiveWorkbenchShell();
        CoreException nestedException = null;
        IStatus status = exception.getStatus();
        if (status != null && status.getException() instanceof CoreException) {
            nestedException = (CoreException)status.getException();
        }
        if (nestedException != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)nestedException.getStatus());
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    public static IFile getFile(IStructuredDocument document) {
        IEditorPart editor;
        if (document != null) {
            try {
                IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(document);
                IFile resource = null;
                try {
                    String baselocation = model.getBaseLocation();
                    if (baselocation != null) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        Path filePath = new Path(baselocation);
                        if (filePath.segmentCount() > 0) {
                            resource = root.getFile((IPath)filePath);
                        }
                    }
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
                return resource;
            }
            catch (Exception exception) {}
        }
        if ((editor = SpringUIUtils.getActiveEditor()) != null && editor.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
        return null;
    }

    public static void openUrl(String location) {
        SpringUIUtils.openUrl(location, 0);
    }

    private static void openUrl(String location, int customFlags) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception exception) {}
            } else {
                IWebBrowser browser = null;
                int flags = customFlags;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                String generatedId = "org.springsource.ide.eclipse.commons.ui-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser init error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException malformedURLException) {}
    }
}

