/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.springsource.ide.eclipse.commons.ui.tips.TipOfTheDayPopup;
import org.springsource.ide.eclipse.commons.ui.tips.TipProvider;

public class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springsource.ide.eclipse.commons.ui";
    public static final String SHOW_TIP_O_DAY = "show.tip";
    private static UiPlugin plugin;
    private TipProvider provider;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        final IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault(SHOW_TIP_O_DAY, true);
        if (preferenceStore.getBoolean(SHOW_TIP_O_DAY)) {
            UIJob tipJob = new UIJob("Spring Tool Tips"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Shell shell = UiPlugin.getActiveWorkbenchShell();
                    if (shell != null) {
                        new TipOfTheDayPopup(shell, preferenceStore, UiPlugin.this.getTipProvider()).open();
                    }
                    return Status.OK_STATUS;
                }
            };
            tipJob.schedule();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static UiPlugin getDefault() {
        return plugin;
    }

    public TipProvider getTipProvider() {
        if (this.provider == null) {
            this.provider = new TipProvider();
        }
        return this.provider;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        final IWorkbenchWindow[] activeWindow = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                activeWindow[0] = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return activeWindow[0];
    }

    public static Shell getActiveWorkbenchShell() {
        return UiPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return UiPlugin.getActiveWorkbenchWindow().getActivePage();
    }
}

