/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator.helper;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.SpringProject;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidationContext;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlValidationContextHelper
extends AbstractValidationContext
implements IXmlValidationContext {
    private final IDOMNode node;
    private final BeansEditorValidator validator;
    private final boolean reportError;
    private final AttrImpl attribute;
    private final IReporter reporter;
    private boolean errorFound;
    private ClassReaderFactory classReaderFactory;
    private final IProject project;
    private IProjectClassLoaderSupport projectClassLoaderSupport;
    private final IFile file;
    private final BeansValidationContext delegateContext;

    public XmlValidationContextHelper(BeansEditorValidator validator, AttrImpl attribute, IDOMNode node, IFile file, IBeansConfig config, IResourceModelElement contextElement, IReporter reporter, boolean reportError) {
        super((IResourceModelElement)config, contextElement);
        this.validator = validator;
        this.reporter = reporter;
        this.reportError = reportError;
        this.attribute = attribute;
        this.node = node;
        this.project = file.getProject();
        this.file = file;
        this.delegateContext = new BeansValidationContext(config, (IResourceModelElement)new SpringProject(SpringCore.getModel(), file.getProject()));
        this.errorFound = false;
    }

    public void error(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(message, 1);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.error(element, problemId, message, attributes);
    }

    public void error(Node node, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(message, 1);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.error((IResourceModelElement)new SpringProject(SpringCore.getModel(), this.project), problemId, message, attributes);
    }

    public ClassReaderFactory getClassReaderFactory() {
        if (this.classReaderFactory == null) {
            this.classReaderFactory = new CachingClassReaderFactory(JdtUtils.getClassLoader((IProject)this.project, (ClassLoader)BeansCorePlugin.getClassLoader()));
        }
        return this.classReaderFactory;
    }

    public BeanDefinitionRegistry getCompleteRegistry() {
        return this.delegateContext.getCompleteRegistry();
    }

    public IResourceModelElement getContextElement() {
        return this.delegateContext.getContextElement();
    }

    public boolean getErrorFound() {
        return this.errorFound;
    }

    public BeanDefinitionRegistry getIncompleteRegistry() {
        return this.delegateContext.getIncompleteRegistry();
    }

    public IProjectClassLoaderSupport getProjectClassLoaderSupport() {
        if (this.projectClassLoaderSupport == null) {
            this.projectClassLoaderSupport = JdtUtils.getProjectClassLoaderSupport((IProject)this.project, null);
        }
        return this.projectClassLoaderSupport;
    }

    public Set<BeanDefinition> getRegisteredBeanDefinition(String beanName, String beanClass) {
        return this.delegateContext.getRegisteredBeanDefinition(beanName, beanClass);
    }

    public IProject getRootElementProject() {
        return this.project;
    }

    public IResource getRootElementResource() {
        return this.file;
    }

    public List<ToolAnnotationUtils.ToolAnnotationData> getToolAnnotation(Node n, String attributeName) {
        return this.delegateContext.getToolAnnotation(n, attributeName);
    }

    public void info(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(message, 4);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.info((IResourceModelElement)new SpringProject(SpringCore.getModel(), this.project), problemId, message, attributes);
    }

    public void info(Node node, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(problemId, 4);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.info((IResourceModelElement)new SpringProject(SpringCore.getModel(), this.project), problemId, message, attributes);
    }

    public boolean isBeanRegistered(String beanName, String beanClass) {
        Set<BeanDefinition> bds = this.getRegisteredBeanDefinition(beanName, beanClass);
        return bds != null && bds.size() > 0;
    }

    public void warning(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(problemId, 2);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.warning((IResourceModelElement)new SpringProject(SpringCore.getModel(), this.project), problemId, message, attributes);
    }

    public void warning(Node node, String problemId, String message, ValidationProblemAttribute ... attributes) {
        int severity = this.getSeverity(problemId, 2);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, QuickfixProcessorFactory.NAMESPACE_ELEMENTS, false, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.warning((IResourceModelElement)new SpringProject(SpringCore.getModel(), this.project), problemId, message, attributes);
    }

    protected int getSeverity(String messageId, int defaultSeverity) {
        switch (defaultSeverity) {
            case 1: {
                defaultSeverity = 2;
                break;
            }
            case 2: {
                defaultSeverity = 1;
                break;
            }
            case 4: {
                defaultSeverity = 0;
            }
        }
        int severity = super.getSeverity(messageId, defaultSeverity);
        switch (severity) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        return -1;
    }
}

