/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.PropertyValue;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.w3c.dom.Node;

public class BeanPropertyHelper
extends BeanProperty
implements IBeanProperty {
    private final IBean parentBean;
    private final IDOMNode propNode;
    private final IFile file;

    private static String getElementName(IDOMNode n) {
        Node id = n.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_NAME);
        if (id != null) {
            return id.getNodeValue();
        }
        return null;
    }

    private static String getElementValue(IDOMNode n) {
        Node value = n.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_VALUE);
        if (value != null) {
            return value.getNodeValue();
        }
        value = n.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_REF);
        if (value != null) {
            return value.getNodeValue();
        }
        return null;
    }

    public BeanPropertyHelper(IDOMNode propNode, IFile file, IBean parentBean) {
        super(parentBean, new PropertyValue(BeanPropertyHelper.getElementName(propNode), (Object)BeanPropertyHelper.getElementValue(propNode)));
        this.parentBean = parentBean;
        this.file = file;
        this.propNode = propNode;
        this.setElementSourceLocation(new IModelSourceLocation(){

            public int getEndLine() {
                return 0;
            }

            public Resource getResource() {
                return new FileResource(BeanPropertyHelper.this.file);
            }

            public int getStartLine() {
                return 0;
            }
        });
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            visitor.visit((IModelElement)this, monitor);
        }
    }

    public IModelElement[] getElementChildren() {
        return new IModelElement[0];
    }

    public String getElementName() {
        return BeanPropertyHelper.getElementName(this.propNode);
    }

    public IModelElement getElementParent() {
        return this.parentBean;
    }

    public IResource getElementResource() {
        return this.file;
    }

    public IResourceModelElement getElementSourceElement() {
        return this.parentBean;
    }

    public int getElementType() {
        return 9;
    }

    public Object getValue() {
        return BeanPropertyHelper.getElementValue(this.propNode);
    }
}

