/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickfixReflectionUtils {
    public static boolean applyProposal(Object proposal, IDocument document) {
        try {
            Method method = proposal.getClass().getMethod("apply", IDocument.class);
            method.invoke(proposal, document);
            return true;
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return false;
    }

    public static Object callProtectedMethod(Object target, String methodName) {
        Class<?> clazz = target.getClass();
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(target, new Object[0]);
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    public static Object[] createChangeDescriptionArray(int length) {
        Class<?> clazz = QuickfixReflectionUtils.getChangeMethodInnerClass("ChangeDescription");
        if (clazz == null) {
            return null;
        }
        Object array = Array.newInstance(clazz, length);
        return (Object[])array;
    }

    public static Object createChangeMethodSignatureProposal(String label, ICompilationUnit targetCU, ClassInstanceCreation invocationNode, IMethodBinding methodBinding, Object[] changeDesc, int relevance, Image image) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposal");
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.ChangeMethodSignatureProposal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
                return null;
            }
        }
        Class<?> arrayClass = QuickfixReflectionUtils.createChangeDescriptionArray(0).getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class, ICompilationUnit.class, ASTNode.class, IMethodBinding.class, arrayClass, arrayClass, Integer.TYPE, Image.class);
            return constructor.newInstance(label, targetCU, invocationNode, methodBinding, changeDesc, null, relevance, image);
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InstantiationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    public static Object createInsertDescription(ITypeBinding objectBinding, String name) {
        Class<?> clazz = QuickfixReflectionUtils.getChangeMethodInnerClass("InsertDescription");
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(ITypeBinding.class, String.class);
            return constructor.newInstance(objectBinding, name);
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InstantiationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    public static Object createNewFieldProposal(String label, ICompilationUnit targetCU, SimpleName simpleName, ITypeBinding binding, int relevance, Image image) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposal");
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.NewVariableCompletionProposal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
                return null;
            }
        }
        try {
            int variableKind = clazz.getField("FIELD").getInt(null);
            Constructor<?> constructor = clazz.getConstructor(String.class, ICompilationUnit.class, Integer.TYPE, SimpleName.class, ITypeBinding.class, Integer.TYPE, Image.class);
            return constructor.newInstance(label, targetCU, variableKind, simpleName, binding, relevance, image);
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchFieldException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InstantiationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    public static Object createNewMethodProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, List<?> arguments, ITypeBinding binding, int relevance, Image image) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposal");
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName("org.eclipse.jdt.internal.ui.text.correction.NewMethodCompletionProposal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
                return null;
            }
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class, ICompilationUnit.class, ASTNode.class, List.class, ITypeBinding.class, Integer.TYPE, Image.class);
            return constructor.newInstance(label, targetCU, invocationNode, arguments, binding, relevance, image);
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InstantiationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    public static Object createRemoveDescription() {
        Class<?> clazz = QuickfixReflectionUtils.getChangeMethodInnerClass("RemoveDescription");
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (NoSuchMethodException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalArgumentException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InstantiationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (IllegalAccessException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
        }
        return null;
    }

    private static Class<?> getChangeMethodInnerClass(String innerClassName) {
        Class<?> clazz = null;
        String className = "org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposal";
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            className = "org.eclipse.jdt.internal.ui.text.correction.ChangeMethodSignatureProposal";
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "reflection error", (Throwable)e));
                return null;
            }
        }
        Class<?>[] innerClasses = clazz.getClasses();
        Class<?> innerClazz = null;
        String changeDescriptionClassName = String.valueOf(className) + "." + innerClassName;
        Class<?>[] classArray = innerClasses;
        int n = innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            String name = innerClass.getCanonicalName();
            if (name != null && name.equals(changeDescriptionClassName)) {
                innerClazz = innerClass;
                break;
            }
            ++n2;
        }
        return innerClazz;
    }

    public static IPath getRelativePath(IPath basePath, IPath path) {
        try {
            Method method = IPath.class.getMethod("makeRelativeTo", IPath.class);
            return (IPath)method.invoke((Object)path, basePath);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        int commonLength = path.matchingFirstSegments(basePath);
        int differenceLength = basePath.segmentCount() - commonLength;
        int newSegmentLength = differenceLength + path.segmentCount() - commonLength;
        if (newSegmentLength == 0) {
            return Path.EMPTY;
        }
        Object[] newSegments = new String[newSegmentLength];
        Arrays.fill(newSegments, 0, differenceLength, "..");
        System.arraycopy(path.segments(), commonLength, newSegments, differenceLength, newSegmentLength - differenceLength);
        Path result = new Path(null, (String)newSegments[0]);
        int i = 1;
        while (i < newSegments.length) {
            result = result.append((String)newSegments[i]);
            ++i;
        }
        return result;
    }
}

