/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPropertyQuickFixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private final List<String> missingProperties;
    private final IDOMNode beanNode;
    private final String label;

    public AddPropertyQuickFixProposal(int offset, int length, boolean missingEndQuote, List<String> missingProperties, IDOMNode beanNode, String label) {
        super(offset, length, missingEndQuote);
        this.missingProperties = missingProperties;
        this.beanNode = beanNode;
        this.label = label;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        IStructuredModel model = null;
        try {
            if (document instanceof IStructuredDocument) {
                model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
                model.beginRecording((Object)this);
            }
            Document ownerDocument = this.beanNode.getOwnerDocument();
            NodeList childNodes = this.beanNode.getChildNodes();
            Node lastProperty = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                String nodeName = child.getNodeName();
                if (nodeName != null && nodeName.equals(BeansSchemaConstants.ELEM_PROPERTY)) {
                    lastProperty = child;
                }
                ++i;
            }
            Node nextSibling = null;
            if (lastProperty != null) {
                nextSibling = lastProperty.getNextSibling();
            }
            FormatProcessorXML formatter = new FormatProcessorXML();
            Element[] properties = new Element[this.missingProperties.size()];
            int i2 = 0;
            while (i2 < this.missingProperties.size()) {
                properties[i2] = ownerDocument.createElement(BeansSchemaConstants.ELEM_PROPERTY);
                properties[i2].setAttribute(BeansSchemaConstants.ATTR_NAME, this.missingProperties.get(i2));
                if (nextSibling != null) {
                    this.beanNode.insertBefore((Node)properties[i2], nextSibling);
                } else {
                    this.beanNode.appendChild((Node)properties[i2]);
                }
                ++i2;
            }
            formatter.formatNode((Node)this.beanNode);
            if (model != null) {
                model.endRecording((Object)this);
            }
            LinkedModeModel linkModel = new LinkedModeModel();
            boolean hasPositions = false;
            Element[] elementArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                formatter.formatNode((Node)element);
                if (element instanceof ElementImpl) {
                    ElementImpl elementImpl = (ElementImpl)element;
                    int nodeOffset = elementImpl.getStartEndOffset() - 1;
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    try {
                        group.addPosition(new LinkedPosition(document, nodeOffset, 0));
                        linkModel.addGroup(group);
                        hasPositions = true;
                    }
                    catch (BadLocationException badLocationException) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Unable to create linked model for property quick fix"));
                    }
                }
                ++n2;
            }
            StructuredTextViewer viewer = null;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor != null && editor instanceof IConfigEditor) {
                viewer = ((IConfigEditor)editor).getTextViewer();
            }
            if (hasPositions && viewer != null) {
                try {
                    linkModel.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(linkModel, (ITextViewer)viewer);
                    ui.enter();
                }
                catch (BadLocationException badLocationException) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Unable to create linked model for property quick fix"));
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public String getDisplayString() {
        return this.label;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
    }
}

