/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddConstructorArgQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final int numAdditionalArgs;
    private final IDOMNode beanNode;
    private final String label;

    public AddConstructorArgQuickFixProposal(int offset, int length, boolean missingEndQuote, int numAdditionalArgs, IDOMNode beanNode, String label) {
        super(offset, length, missingEndQuote);
        this.numAdditionalArgs = numAdditionalArgs;
        this.beanNode = beanNode;
        this.label = label;
    }

    public void applyQuickFix(IDocument document) {
        IStructuredModel model = null;
        try {
            if (document instanceof IStructuredDocument) {
                model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
                model.beginRecording((Object)this);
            }
            Document ownerDocument = this.beanNode.getOwnerDocument();
            NodeList childNodes = this.beanNode.getChildNodes();
            Node lastConstructorArg = null;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                String nodeName = child.getNodeName();
                if (nodeName != null && nodeName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                    lastConstructorArg = child;
                }
                ++i;
            }
            Node nextSibling = null;
            if (lastConstructorArg != null) {
                nextSibling = lastConstructorArg.getNextSibling();
            }
            FormatProcessorXML formatter = new FormatProcessorXML();
            Element[] constructorArgs = new Element[this.numAdditionalArgs];
            int i2 = 0;
            while (i2 < this.numAdditionalArgs) {
                constructorArgs[i2] = ownerDocument.createElement(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG);
                if (nextSibling != null) {
                    this.beanNode.insertBefore((Node)constructorArgs[i2], nextSibling);
                } else {
                    this.beanNode.appendChild((Node)constructorArgs[i2]);
                }
                ++i2;
            }
            formatter.formatNode((Node)this.beanNode);
            if (model != null) {
                model.endRecording((Object)this);
            }
            LinkedModeModel linkModel = new LinkedModeModel();
            boolean hasPositions = false;
            Element[] elementArray = constructorArgs;
            int n = constructorArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                formatter.formatNode((Node)element);
                if (element instanceof ElementImpl) {
                    ElementImpl elementImpl = (ElementImpl)element;
                    int nodeOffset = elementImpl.getStartEndOffset() - 1;
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    try {
                        group.addPosition(new LinkedPosition(document, nodeOffset, 0));
                        linkModel.addGroup(group);
                        hasPositions = true;
                    }
                    catch (BadLocationException badLocationException) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Unable to create linked model for constructor arg quick fix"));
                    }
                }
                ++n2;
            }
            StructuredTextViewer viewer = null;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor != null && editor instanceof IConfigEditor) {
                viewer = ((IConfigEditor)editor).getTextViewer();
            }
            if (hasPositions && viewer != null) {
                try {
                    linkModel.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(linkModel, (ITextViewer)viewer);
                    ui.enter();
                }
                catch (BadLocationException badLocationException) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", "Unable to create linked model for constructor arg quick fix"));
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public String getDisplayString() {
        return this.label;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
    }
}

