/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.AddPropertyQuickFixProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertyQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final List<String> missingProperties;
    private final IDOMNode beanNode;

    public RequiredPropertyQuickAssistProcessor(int offset, int length, String text, boolean missingEndQuote, List<String> missingProperties, IDOMNode beanNode) {
        super(offset, length, text, missingEndQuote);
        this.missingProperties = missingProperties;
        this.beanNode = beanNode;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        StringBuilder label = new StringBuilder("Add <property> for ");
        int i = 0;
        while (i < this.missingProperties.size()) {
            if (i > 0) {
                label.append(", ");
            }
            label.append(this.missingProperties.get(i));
            ++i;
        }
        return new ICompletionProposal[]{new AddPropertyQuickFixProposal(this.offset, this.length, this.missingEndQuote, this.missingProperties, this.beanNode, label.toString())};
    }
}

