/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.web.bind.annotation.PathVariable;

public class RequestMappingVariableCompletionProposal
extends AnnotationCompletionProposal {
    private final MethodDeclaration decl;
    private final SingleVariableDeclaration param;
    private final String variableName;
    private StringLiteral oldTemplate;
    private String newTemplateString;
    private int cursorOffset;

    public RequestMappingVariableCompletionProposal(SingleVariableDeclaration param, int startPos, int length, Annotation annotation, MethodDeclaration decl, JavaContentAssistInvocationContext javaContext) {
        this(param, param.getName().getFullyQualifiedName(), startPos, length, annotation, decl, javaContext);
    }

    public RequestMappingVariableCompletionProposal(SingleVariableDeclaration param, String variableName, int startPos, int length, Annotation annotation, MethodDeclaration decl, JavaContentAssistInvocationContext javaContext) {
        super("", javaContext.getCompilationUnit(), QuickfixImages.getImage(QuickfixImages.LOCAL_VARIABLE));
        this.param = param;
        this.variableName = variableName;
        this.decl = decl;
        this.setUpProposal(startPos, length, annotation);
        if (param != null && ProposalCalculatorUtil.hasAnnotation("PathVariable", (ASTNode)param)) {
            this.setRelevance(100);
        }
    }

    private void setUpProposal(int startPos, int length, Annotation annotation) {
        String typeName = ProposalCalculatorUtil.getTypeName(this.param.getType());
        StringBuilder displayName = new StringBuilder();
        displayName.append(this.variableName);
        displayName.append(": ");
        displayName.append(typeName);
        displayName.append(" - ");
        displayName.append(this.decl.getName().getFullyQualifiedName());
        displayName.append("(");
        List params = this.decl.parameters();
        int i = 0;
        while (i < params.size()) {
            if (i > 0) {
                displayName.append(", ");
            }
            SingleVariableDeclaration currentParam = (SingleVariableDeclaration)params.get(i);
            displayName.append(ProposalCalculatorUtil.getTypeName(currentParam.getType()));
            displayName.append(" ");
            if (currentParam == this.param) {
                displayName.append(this.variableName);
            } else {
                displayName.append(currentParam.getName().getFullyQualifiedName());
            }
            ++i;
        }
        displayName.append(")");
        this.setDisplayName(displayName.toString());
        if (annotation instanceof NormalAnnotation) {
            List pairs = ((NormalAnnotation)annotation).values();
            for (MemberValuePair pair : pairs) {
                Expression expression = pair.getValue();
                int valueStartPos = expression.getStartPosition();
                int valueLength = expression.getLength();
                if (valueStartPos > startPos || valueStartPos + valueLength < startPos + length) continue;
                this.setUpProposal(pair.getValue(), startPos, length);
                break;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            this.setUpProposal(((SingleMemberAnnotation)annotation).getValue(), startPos, length);
        }
    }

    private void setUpProposal(Expression expression, int startPos, int length) {
        int valueStartPos = expression.getStartPosition();
        int valueLength = expression.getLength();
        if (expression instanceof StringLiteral) {
            StringLiteral stringLiteral;
            this.oldTemplate = stringLiteral = (StringLiteral)expression;
            int lengthDiff = (valueLength -= 2) - length;
            int offset = startPos - ++valueStartPos;
            int remainingLength = lengthDiff - offset;
            StringBuffer buffer = new StringBuffer();
            String literalValue = stringLiteral.getLiteralValue();
            buffer.append(literalValue.substring(0, startPos - valueStartPos));
            buffer.append(this.variableName);
            buffer.append(literalValue.substring(valueLength - remainingLength));
            this.cursorOffset = startPos - valueStartPos;
            this.newTemplateString = buffer.toString();
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.decl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.newTemplateString == null || this.oldTemplate == null) {
            return rewrite;
        }
        boolean isLinked = false;
        if (this.param != null && !ProposalCalculatorUtil.hasAnnotation("PathVariable", (ASTNode)this.param)) {
            String requestMappingTypeName = PathVariable.class.getCanonicalName();
            if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), requestMappingTypeName)) {
                CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.decl);
                ImportRewrite importRewrite = this.createImportRewrite(astRoot);
                importRewrite.addImport(requestMappingTypeName);
            }
            SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
            annotation.setTypeName((Name)ast.newSimpleName("PathVariable"));
            StringLiteral pathVariableName = ast.newStringLiteral();
            pathVariableName.setLiteralValue(this.variableName);
            ITrackedNodePosition trackPathVariable = rewrite.track((ASTNode)pathVariableName);
            this.addLinkedPosition(new StringLiteralTrackedPosition(trackPathVariable), true, "PathVariable");
            annotation.setValue((Expression)pathVariableName);
            isLinked = true;
            ChildListPropertyDescriptor property = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
            rewrite.getListRewrite((ASTNode)this.param, property).insertLast((ASTNode)annotation, null);
        }
        StringLiteral newTemplate = ast.newStringLiteral();
        newTemplate.setLiteralValue(this.newTemplateString);
        ITrackedNodePosition trackTemplateVariable = rewrite.track((ASTNode)newTemplate);
        rewrite.replace((ASTNode)this.oldTemplate, (ASTNode)newTemplate, null);
        if (isLinked) {
            this.addLinkedPosition(new StringLiteralTrackedPosition(trackTemplateVariable, this.cursorOffset, this.variableName.length(), false), false, "PathVariable");
        } else {
            this.setTrackPosition(new StringLiteralTrackedPosition(trackTemplateVariable, this.cursorOffset + this.variableName.length(), 0, true));
        }
        return rewrite;
    }
}

