/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.MarkerResolutionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddQualiferToMethodParamCompletionProposal
extends MarkerResolutionProposal {
    private final MethodDeclaration methodDecl;
    private final List<SingleVariableDeclaration> params;

    public AddQualiferToMethodParamCompletionProposal(List<SingleVariableDeclaration> params, MethodDeclaration methodDecl, ICompilationUnit cu) {
        super(AddQualiferToMethodParamCompletionProposal.getDisplayName(params, methodDecl), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.params = params;
        this.methodDecl = methodDecl;
    }

    private SingleMemberAnnotation createAnnotation(SingleVariableDeclaration decl, String qualifiedName, String simpleName, CompilationUnit astRoot, AST ast, ASTRewrite astRewrite, ImportRewrite importRewrite, boolean multiple, int pos) {
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), qualifiedName)) {
            importRewrite.addImport(qualifiedName);
        }
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(simpleName));
        StringLiteral literal = ast.newStringLiteral();
        annotation.setValue((Expression)literal);
        this.setTrackPosition(new StringLiteralTrackedPosition(astRewrite.track((ASTNode)literal)));
        ChildListPropertyDescriptor property = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
        astRewrite.getListRewrite((ASTNode)decl, property).insertLast((ASTNode)annotation, null);
        if (multiple) {
            this.addLinkedPosition(new StringLiteralTrackedPosition(astRewrite.track((ASTNode)literal)), pos == 0, "Qualifier " + pos);
        }
        return annotation;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.methodDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        ImportRewrite importRewrite = this.createImportRewrite(astRoot);
        int i = 0;
        while (i < this.params.size()) {
            this.createAnnotation(this.params.get(i), Qualifier.class.getCanonicalName(), "Qualifier", astRoot, ast, astRewrite, importRewrite, this.params.size() > 0, i);
            ++i;
        }
        return astRewrite;
    }

    private static String getDisplayName(List<SingleVariableDeclaration> params, MethodDeclaration methodDecl) {
        StringBuffer buf = new StringBuffer();
        buf.append("Add @Qualifier for ");
        int i = 0;
        while (i < params.size()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(params.get(i).getName().getFullyQualifiedName());
            ++i;
        }
        return buf.toString();
    }
}

