/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.springframework.ide.eclipse.quickfix.jdt.MissingPathVariableWarning;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCompilationParticipant
extends CompilationParticipant {
    private List<String> findPathVariables(AbstractTypeDeclaration typeDecl) {
        ArrayList<String> pathVariables = new ArrayList<String>();
        List bodyDecls = typeDecl.bodyDeclarations();
        for (BodyDeclaration bodyDecl : bodyDecls) {
            if (!(bodyDecl instanceof MethodDeclaration)) continue;
            MethodDeclaration methodDecl = (MethodDeclaration)bodyDecl;
            pathVariables.addAll(this.findPathVariables(methodDecl));
        }
        return pathVariables;
    }

    private List<String> findPathVariables(ITypeBinding typeBinding) {
        IMethodBinding[] methods;
        ArrayList<String> pathVariables = new ArrayList<String>();
        if (typeBinding == null) {
            return pathVariables;
        }
        IMethodBinding[] iMethodBindingArray = methods = typeBinding.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            int i = 0;
            while (i < method.getParameterTypes().length) {
                IAnnotationBinding[] annotations;
                IAnnotationBinding[] iAnnotationBindingArray = annotations = method.getParameterAnnotations(i);
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotationBinding annotation = iAnnotationBindingArray[n4];
                    if ("PathVariable".equals(annotation.getName())) {
                        IJavaElement javaMethod;
                        IMemberValuePairBinding[] memberValuePairs = annotation.getAllMemberValuePairs();
                        String valueStr = null;
                        IMemberValuePairBinding[] iMemberValuePairBindingArray = memberValuePairs;
                        int n5 = memberValuePairs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object value;
                            IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n6];
                            if ("value".equals(memberValuePair.getName()) && (value = memberValuePair.getValue()) instanceof String) {
                                valueStr = (String)value;
                            }
                            ++n6;
                        }
                        if ((valueStr == null || valueStr.length() == 0) && (javaMethod = method.getJavaElement()) instanceof IMethod) {
                            try {
                                valueStr = ((IMethod)javaMethod).getParameterNames()[i];
                            }
                            catch (JavaModelException javaModelException) {}
                        }
                        if (valueStr != null) {
                            pathVariables.add(valueStr);
                        }
                    }
                    ++n4;
                }
                ++i;
            }
            ++n2;
        }
        pathVariables.addAll(this.findPathVariables(typeBinding.getSuperclass()));
        return pathVariables;
    }

    private List<String> findPathVariables(MethodDeclaration methodDecl) {
        ArrayList<String> pathVariables = new ArrayList<String>();
        List params = methodDecl.parameters();
        for (SingleVariableDeclaration param : params) {
            String variableName = ProposalCalculatorUtil.getPathVariableName(param);
            if (variableName == null) continue;
            pathVariables.add(variableName);
        }
        return pathVariables;
    }

    public void reconcile(ReconcileContext context) {
        if (context.getDelta() == null) {
            return;
        }
        CompilationUnit cuAST = context.getDelta().getCompilationUnitAST();
        ICompilationUnit cu = context.getWorkingCopy();
        IFile file = (IFile)cu.getResource();
        ArrayList<MissingPathVariableWarning> problems = new ArrayList<MissingPathVariableWarning>();
        if (cuAST != null) {
            List typeDecls = cuAST.types();
            for (AbstractTypeDeclaration typeDecl : typeDecls) {
                List<Object> pathVariables;
                List bodyDecls = typeDecl.bodyDeclarations();
                for (BodyDeclaration bodyDecl : bodyDecls) {
                    if (!(bodyDecl instanceof MethodDeclaration)) continue;
                    MethodDeclaration methodDecl = (MethodDeclaration)bodyDecl;
                    List<String> currentPathVariables = this.findPathVariables(methodDecl);
                    Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("RequestMapping", (ASTNode)methodDecl);
                    for (Annotation annotation : annotations) {
                        List<UriTemplateVariable> variables = ProposalCalculatorUtil.getUriTemplatVariables(annotation);
                        for (UriTemplateVariable variable : variables) {
                            boolean found = false;
                            for (String currentPathVariable : currentPathVariables) {
                                if (!Pattern.matches(variable.getVariableName(), currentPathVariable)) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            problems.add(new MissingPathVariableWarning(annotation, variable, file, cuAST.getLineNumber(variable.getOffset())));
                        }
                    }
                }
                if (context.isResolvingBindings()) {
                    pathVariables = new ArrayList();
                    ITypeBinding typeBinding = typeDecl.resolveBinding();
                    while (typeBinding != null && !typeDecl.getAST().resolveWellKnownType("java.lang.Object").equals((Object)typeBinding)) {
                        pathVariables.addAll(this.findPathVariables(typeBinding));
                        typeBinding = typeBinding.getSuperclass();
                    }
                } else {
                    pathVariables = this.findPathVariables(typeDecl);
                }
                Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("RequestMapping", (ASTNode)typeDecl);
                for (Annotation annotation : annotations) {
                    List<UriTemplateVariable> variables = ProposalCalculatorUtil.getUriTemplatVariables(annotation);
                    for (UriTemplateVariable variable : variables) {
                        if (pathVariables.contains(variable.getVariableName())) continue;
                        problems.add(new MissingPathVariableWarning(annotation, variable, file, cuAST.getLineNumber(variable.getOffset())));
                    }
                }
            }
        }
        context.putProblems("com.springsource.sts.jdt.quickfix.marker", problems.toArray(new CategorizedProblem[problems.size()]));
    }

    public boolean isActive(IJavaProject project) {
        return SpringCoreUtils.isSpringProject((IResource)project.getProject());
    }
}

