/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.hyperlinks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.AutowireDependencyProvider;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.hyperlinks.AutowireBeanHyperlink;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireHyperlinkDetector
extends JavaElementHyperlinkDetector {
    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        IField field;
        if (element instanceof ILocalVariable) {
            IMethod parentMethod;
            ILocalVariable localVariable = (ILocalVariable)element;
            IJavaElement parent = localVariable.getParent();
            if (parent instanceof IMethod && (parentMethod = (IMethod)parent).getAnnotation("Autowired") != null) {
                String typeSignature = localVariable.getTypeSignature();
                this.addHyperlinksHelper(typeSignature, (IJavaElement)localVariable, hyperlinksCollector);
            }
        } else if (element instanceof IField && (field = (IField)element).getAnnotation("Autowired") != null) {
            try {
                String typeSignature = field.getTypeSignature();
                this.addHyperlinksHelper(typeSignature, (IJavaElement)field, hyperlinksCollector);
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)e.getStatus());
            }
        }
    }

    private void addHyperlinksHelper(String typeSignature, IJavaElement element, List<IHyperlink> hyperlinksCollector) {
        String typeName = Signature.toString((String)typeSignature);
        try {
            String[][] qualifiedTypeNames;
            IType type = this.getParentType(element);
            if (type != null && (qualifiedTypeNames = type.resolveType(typeName)) != null) {
                String[][] stringArray = qualifiedTypeNames;
                int n = qualifiedTypeNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] typeNameSegments = stringArray[n2];
                    StringBuilder qualifiedTypeName = new StringBuilder();
                    String[] stringArray2 = typeNameSegments;
                    int n3 = typeNameSegments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String typeNameSegment = stringArray2[n4];
                        if (qualifiedTypeName.length() > 0) {
                            qualifiedTypeName.append(".");
                        }
                        qualifiedTypeName.append(typeNameSegment);
                        ++n4;
                    }
                    this.addHyperlinksHelper(qualifiedTypeName.toString(), element.getJavaProject().getProject(), hyperlinksCollector);
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
    }

    private void addHyperlinksHelper(String typeName, IProject project, List<IHyperlink> hyperlinksCollector) {
        IBeansModel model = BeansCorePlugin.getModel();
        IBeansProject springProject = model.getProject(project);
        if (springProject == null) {
            return;
        }
        Set configs = springProject.getConfigs();
        HashSet<AutowireBeanHyperlink> hyperlinks = new HashSet<AutowireBeanHyperlink>();
        for (IBeansConfig config : configs) {
            this.addHyperlinksHelper(config, typeName, project, hyperlinks);
        }
        if (hyperlinks.size() == 1) {
            ((AutowireBeanHyperlink)hyperlinks.iterator().next()).setIsOnlyCandidate(true);
        }
        hyperlinksCollector.addAll(hyperlinks);
    }

    public void addHyperlinksHelper(IBeansConfig config, final String typeName, IProject project, Set<AutowireBeanHyperlink> hyperlinks) {
        String[] beanNames;
        final AutowireDependencyProvider autowireDependencyProvider = new AutowireDependencyProvider((IBeansModelElement)config, (IBeansModelElement)config);
        final String[][] beanNamesWrapper = new String[1][];
        try {
            IProjectClassLoaderSupport classLoaderSupport = JdtUtils.getProjectClassLoaderSupport((IProject)project.getProject(), null);
            autowireDependencyProvider.setProjectClassLoaderSupport(classLoaderSupport);
            classLoaderSupport.executeCallback(new IProjectClassLoaderSupport.IProjectClassLoaderAwareCallback(){

                public void doWithActiveProjectClassLoader() throws Throwable {
                    autowireDependencyProvider.preloadClasses();
                    beanNamesWrapper[0] = autowireDependencyProvider.getBeansForType(typeName);
                }
            });
        }
        catch (Throwable e) {
            BeansCorePlugin.log((Throwable)e);
        }
        String[] stringArray = beanNames = beanNamesWrapper[0];
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            IBean bean = autowireDependencyProvider.getBean(beanName);
            IResource resource = bean.getElementResource();
            int line = bean.getElementStartLine();
            if (resource instanceof IFile) {
                AutowireBeanHyperlink newHyperlink = new AutowireBeanHyperlink((IFile)resource, line, beanName);
                boolean found = false;
                for (AutowireBeanHyperlink hyperlink : hyperlinks) {
                    if (!resource.equals((Object)hyperlink.getFile()) || line != hyperlink.getLine()) continue;
                    if (!beanName.equals(hyperlink.getBeanName())) {
                        hyperlink.setShowFileName(true);
                        hyperlinks.add(newHyperlink);
                        newHyperlink.setShowFileName(true);
                        break;
                    }
                    found = true;
                }
                if (!found) {
                    hyperlinks.add(newHyperlink);
                }
            }
            ++n2;
        }
    }

    private IType getParentType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IType) {
            return (IType)element;
        }
        return this.getParentType(element.getParent());
    }
}

