/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix;

import java.util.HashSet;
import java.util.Set;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuickfixSupport {
    public static final String BEAN_NAMESPACE = "http://www.springframework.org/schema/beans";
    private final Set<BeanValidator> validators = new HashSet<BeanValidator>();

    public QuickfixSupport() {
        this.init();
    }

    public Set<BeanValidator> getQuickfixValidators(Node node) {
        HashSet<BeanValidator> matchedValidators = new HashSet<BeanValidator>();
        for (BeanValidator validator : this.validators) {
            if (!validator.accept(node)) continue;
            matchedValidators.add(validator);
        }
        return matchedValidators;
    }

    public Set<BeanValidator> getQuickfixValidators(Node node, Attr attr) {
        HashSet<BeanValidator> matchedValidators = new HashSet<BeanValidator>();
        for (BeanValidator validator : this.validators) {
            if (!validator.acceptAttribute(node, attr)) continue;
            matchedValidators.add(validator);
        }
        return matchedValidators;
    }

    protected abstract void init();

    protected void setAttributeValidator(String namespaceURI, String nodeName, String attributeName, BeanValidator validator) {
        validator.setNamespaceURI(namespaceURI);
        validator.setNodeName(nodeName);
        validator.setAttributeName(attributeName);
        this.validators.add(validator);
    }

    protected void setValidator(String namespaceURI, String nodeName, BeanValidator validator) {
        validator.setNamespaceURI(namespaceURI);
        validator.setNodeName(nodeName);
        this.validators.add(validator);
    }
}

