/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.io.File;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.jst.angularjs.AngularJsPlugin;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicConstants;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicVersion;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicVersionPage;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicWizardMessages;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizardPage;
import org.jboss.tools.jst.web.kb.internal.taglib.html.IHTMLLibraryVersion;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.preferences.js.IPreferredJSLibVersion;
import org.jboss.tools.jst.web.ui.internal.preferences.js.PreferredJSLibVersions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.VersionedNewHTMLWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public abstract class NewIonicWidgetWizard<P extends NewIonicWidgetWizardPage>
extends VersionedNewHTMLWidgetWizard<IonicVersion, P>
implements IonicConstants {
    private IonicVersionPage versionPage;
    PreferredJSLibVersions preferredVersions = null;

    public NewIonicWidgetWizard() {
        super((Object)IonicVersion.IONIC_1_0);
    }

    public void initWithoutUI() {
        this.addPages();
        if (this.page != null) {
            ((NewIonicWidgetWizardPage)this.page).createFields();
        }
        this.versionPage.createFields();
    }

    protected void doAddPages() {
        super.doAddPages();
        this.versionPage = new IonicVersionPage("ionicVersion", "Add References to JS/CSS");
        this.versionPage.setDescription(IonicWizardMessages.versionPageDescription);
        this.addPage((IWizardPage)this.versionPage);
    }

    public PreferredJSLibVersions getPreferredVersions() {
        return this.preferredVersions;
    }

    public void setCommand(IDropCommand command) {
        super.setCommand(command);
        String path = this.getCommandProperties().getProperty("palettePath");
        if (path != null) {
            IonicVersion[] ionicVersionArray = IonicVersion.ALL_VERSIONS;
            int n = IonicVersion.ALL_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                IonicVersion v = ionicVersionArray[n2];
                if (path.indexOf(String.valueOf(PaletteModel.VERSION_PREFIX) + v.toString()) > 0) {
                    this.version = v;
                }
                ++n2;
            }
        }
        this.preferredVersions = new PreferredJSLibVersions(this.getFile(), (IHTMLLibraryVersion)this.getVersion());
        this.preferredVersions.updateLibEnablementAndSelection();
    }

    protected void doPerformFinish() {
        this.preferredVersions.applyLibPreference((IPreferredJSLibVersion)this.versionPage);
        this.preferredVersions.saveLibPreference();
        if (this.page == null || this.isTrue("addJSCSS")) {
            this.getCommandProperties().put("insert jquery mobile js css", this.getVersion());
            this.getCommandProperties().put("preferred-js-lib-versions", this.preferredVersions);
        }
        super.doPerformFinish();
    }

    protected void createHead(IElementGenerator.ElementNode html) {
        String browserType = ((NewIonicWidgetWizardPage)this.page).getBrowserType();
        String styleSheetURI = "css/ionic.min.css";
        String ionicScriptURI = "ionic.bundle.min.js";
        File root = AngularJsPlugin.getJSStateRoot();
        if (root != null) {
            String prefix = "js/";
            if (root.isDirectory()) {
                styleSheetURI = new File(root, String.valueOf(prefix) + styleSheetURI).toURI().toString();
                ionicScriptURI = new File(root, String.valueOf(prefix) + ionicScriptURI).toURI().toString();
            } else if (root.isFile()) {
                String jar = "jar:" + root.toURI().toString() + "!/";
                styleSheetURI = String.valueOf(jar) + prefix + styleSheetURI;
                ionicScriptURI = String.valueOf(jar) + prefix + ionicScriptURI;
            }
        }
        IElementGenerator.ElementNode head = html.addChild("head");
        if ("mozilla".equals(browserType)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n(function() {\n").append("  var originalGetComputedStyle = window.getComputedStyle;\n").append("  window.getComputedStyle = function() {\n").append("    if (arguments.length == 1) {\n").append("      // workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=567350 (getComputedStyle requires both arguments to be supplied)\n").append("      return originalGetComputedStyle.call(this, arguments[0], null);\n").append("    } else {\n").append("      return originalGetComputedStyle.apply(this, arguments);\n").append("    }\n").append("  };\n").append("}());\n");
            head.addChild("script", sb.toString());
        }
        head.addChild("title", "Page Title");
        IElementGenerator.ElementNode meta = head.addChild("meta");
        meta.addAttribute("name", "viewport");
        meta.addAttribute("content", "width=device-width, initial-scale=1");
        IElementGenerator.ElementNode link = head.addChild("link");
        link.addAttribute("rel", "stylesheet");
        link.addAttribute("href", styleSheetURI);
        IElementGenerator.ElementNode script = head.addChild("script", "");
        script.addAttribute("src", ionicScriptURI);
        StringBuilder sb = new StringBuilder();
        sb.append("angular.module('starter', ['ionic'])\n").append(".run(function($ionicPlatform) {\n").append("  $ionicPlatform.ready(function() {\n").append("   if(window.StatusBar) {\n").append("    StatusBar.styleDefault();\n").append("   }\n").append("  });\n").append("})\n");
        head.addChild("script", sb.toString());
    }

    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        body.addAttribute("ng-app", "starter");
        this.addContent(body, true);
    }

    protected final void addContent(IElementGenerator.ElementNode parent) {
        this.addContent(parent, false);
    }

    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
    }

    public static PaletteItemResult runWithoutUi(JSPTextEditor textEditor, IonicVersion version, String item) {
        return NewIonicWidgetWizard.runWithoutUi((JSPTextEditor)textEditor, (String)"Ionic", (String)version.toString(), (String)item);
    }
}

