/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.angularjs.AngularJsPlugin;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class IonicIconFactory {
    static IonicIconFactory instance = new IonicIconFactory();
    private List<String> icons = null;

    public static IonicIconFactory getInstance() {
        return instance;
    }

    private IonicIconFactory() {
    }

    public List<String> getIcons() {
        if (this.icons == null) {
            try {
                this.load();
            }
            catch (IOException e) {
                this.onLoadFail(e);
            }
            catch (URISyntaxException e) {
                this.onLoadFail(e);
            }
        }
        return this.icons;
    }

    private void onLoadFail(Exception e) {
        AngularJsPlugin.getDefault().logError(e);
        this.icons = new ArrayList<String>();
    }

    private void load() throws IOException, URISyntaxException {
        File root = AngularJsPlugin.getJSStateRoot();
        URI uri = null;
        if (root.isDirectory()) {
            uri = new File(root, "js/fonts/ionicons.svg").toURI();
        } else if (root.isFile()) {
            uri = new URI("jar:" + root.toURI().toString() + "!/" + "js/fonts/ionicons.svg");
        }
        InputStream is = uri.toURL().openStream();
        Element e = XMLUtilities.getElement((InputStream)is, (EntityResolver)XMLEntityResolver.getInstance());
        Element defs = XMLUtilities.getUniqueChild((Element)e, (String)"defs");
        Element font = XMLUtilities.getUniqueChild((Element)defs, (String)"font");
        Element[] glyphs = XMLUtilities.getChildren((Element)font, (String)"glyph");
        ArrayList<String> icons = new ArrayList<String>();
        Element[] elementArray = glyphs;
        int n = glyphs.length;
        int n2 = 0;
        while (n2 < n) {
            Element g = elementArray[n2];
            icons.add(g.getAttribute("glyph-name"));
            ++n2;
        }
        this.icons = icons;
    }
}

