/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.HTMLRecognizer;
import org.jboss.tools.jst.web.kb.internal.JSRecognizer;
import org.jboss.tools.jst.web.kb.internal.JspContextImpl;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IonicRecognizer
extends HTMLRecognizer {
    private static final String JS_LIB_NAME = "ionic";

    protected boolean recalculateResult(ITagLibrary lib, ELContext context, IFile file) {
        return FileUtil.isDoctypeHTML((IFile)file) ? JSRecognizer.getJSReferenceVersion((IFile)file, (String)JS_LIB_NAME) != null : context instanceof JspContextImpl && IonicRecognizer.isAngularTemplate(file);
    }

    public static boolean isReferencingIonicLib(IFile file) {
        return JSRecognizer.getJSReferenceVersion((IFile)file, (String)JS_LIB_NAME) != null;
    }

    public static boolean isAngularTemplate(IFile file) {
        if (!file.getName().toLowerCase().endsWith(".html")) {
            return false;
        }
        String doctype = FileUtil.getDoctype((String)FileUtil.getContentFromEditorOrFile((IFile)file));
        if (doctype != null) {
            return false;
        }
        IStructuredModel model = null;
        try {
            IDOMDocument xmlDocument;
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            NodeList list = xmlDocument.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n instanceof Element) {
                    String name = ((Element)n).getNodeName().toLowerCase();
                    return !name.equals("html") && !name.equals("body") && !name.equals("head");
                    {
                    }
                }
                try {
                    ++i;
                    continue;
                }
                catch (IOException e) {
                    WebKbPlugin.getDefault().logError((Throwable)e);
                }
                catch (CoreException e) {
                    WebKbPlugin.getDefault().logError((Throwable)e);
                }
                break;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }
}

