/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.locate.AbstractBeansConfigLocator;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathMatchingBeansConfigLocator
extends AbstractBeansConfigLocator {
    private PathMatcher pathMatcher = new AntPathMatcher();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Set<IFile> locateBeansConfigs(IProject project, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask(String.format("Scanning for Spring configuration files in project '%s'", project.getName()), 3);
        try {
            LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
            if (this.canLocateInProject(project)) {
                progressMonitor.worked(1);
                try {
                    for (IPath rootDir : this.getRootDirectories(project)) {
                        if (progressMonitor.isCanceled()) {
                            Set<IFile> set = Collections.emptySet();
                            return set;
                        }
                        progressMonitor.subTask(String.format("Scanning for Spring configuration files in folder '%s'", rootDir.toString()));
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(rootDir);
                        if (resource instanceof IFolder) {
                            this.locateConfigsInFolder(files, project, (IFolder)resource, rootDir);
                            continue;
                        }
                        if (!(resource instanceof IContainer)) continue;
                        IResource[] iResourceArray = ((IContainer)resource).members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource res = iResourceArray[n2];
                            if (res instanceof IFolder) {
                                this.locateConfigsInFolder(files, project, (IFolder)res, rootDir);
                            } else if (res instanceof IFile) {
                                this.locateConfigInFile(files, project, rootDir, (IFile)res);
                            }
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException e) {
                    BeansCorePlugin.log(e);
                }
                catch (CoreException e) {
                    BeansCorePlugin.log(e);
                }
            }
            if (progressMonitor.isCanceled()) {
                Set<IFile> set = Collections.emptySet();
                return set;
            }
            progressMonitor.worked(1);
            Set<IFile> set = this.filterMatchingFiles(files);
            return set;
        }
        finally {
            progressMonitor.worked(1);
            progressMonitor.done();
        }
    }

    private boolean matches(String filePath, String pattern) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        if (!pattern.startsWith("/")) {
            pattern = "/" + pattern;
        }
        return this.pathMatcher.match(pattern, filePath);
    }

    protected boolean canLocateInProject(IProject project) {
        return true;
    }

    protected void doLocateConfig(Set<IFile> files, IProject project, IFile file) {
    }

    protected Set<IFile> filterMatchingFiles(Set<IFile> files) {
        return files;
    }

    protected abstract Set<String> getAllowedFilePatterns();

    protected void locateConfigsInFolder(Set<IFile> files, IProject project, IFolder folder, IPath rootDir) throws CoreException {
        if (folder != null && folder.exists() && !folder.isDerived()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    this.locateConfigInFile(files, project, rootDir, (IFile)resource);
                } else if (resource instanceof IFolder) {
                    this.locateConfigsInFolder(files, project, (IFolder)resource, rootDir);
                }
                ++n2;
            }
        }
    }

    protected void locateConfigInFile(Set<IFile> files, IProject project, IPath rootDir, IFile resource) {
        if (!resource.isDerived()) {
            String filePath = this.removeRootDir(resource.getFullPath(), rootDir);
            for (String pattern : this.getAllowedFilePatterns()) {
                String fileExtension = resource.getFileExtension();
                if (fileExtension != null && this.getAllowedFileExtensions().contains(fileExtension) && this.matches(filePath, pattern)) {
                    files.add(resource);
                }
                this.doLocateConfig(files, project, resource);
            }
        }
    }

    protected String removeRootDir(IPath filePath, IPath rootDir) {
        int segCount = filePath.matchingFirstSegments(rootDir);
        return filePath.removeFirstSegments(segCount).toString();
    }
}

