/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionHandler;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansProjectDescriptionReader {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/project/description/debug";
    public static final boolean DEBUG = SpringCore.isDebug((String)"org.springframework.ide.eclipse.beans.core/project/description/debug");

    public static void read(BeansProject project) {
        IFile file = ((IProject)project.getElementResource()).getFile((IPath)new Path(".springBeans"));
        File rawFile = null;
        if (file != null && file.getLocation() != null) {
            rawFile = file.getLocation().toFile();
        }
        if (!(rawFile != null && rawFile.exists() && rawFile.canRead() || (file = ((IProject)project.getElementResource()).getFile((IPath)new Path(".springBeans"))) == null || file.getLocation() == null)) {
            rawFile = file.getLocation().toFile();
        }
        if (rawFile != null && rawFile.exists() && rawFile.canRead()) {
            BeansProjectDescriptionReader.readDescriptionFromFile(project, file, rawFile);
        }
        project.addConfigSuffix("xml");
    }

    private static void readDescriptionFromFile(BeansProject project, IFile file, File rawFile) {
        block22: {
            if (DEBUG) {
                System.out.println("Reading project description from " + file.getLocation().toString());
            }
            BufferedInputStream is = null;
            try {
                try {
                    is = new BufferedInputStream(new FileInputStream(rawFile));
                    BeansProjectDescriptionHandler handler = new BeansProjectDescriptionHandler(project);
                    try {
                        SAXParser parser = SpringCoreUtils.getSaxParser();
                        parser.parse(new InputSource(is), (DefaultHandler)handler);
                    }
                    catch (SAXException e) {
                        handler.log(4, e);
                    }
                    catch (IOException e) {
                        handler.log(4, e);
                    }
                    IStatus status = handler.getStatus();
                    switch (status.getSeverity()) {
                        case 4: {
                            BeansCorePlugin.log(status);
                            break;
                        }
                        case 1: 
                        case 2: {
                            BeansCorePlugin.log(status);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    BeansCorePlugin.log(e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

