/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringParsingProblemsRule
implements IValidationRule<BeansConfig, IBeansValidationContext> {
    private static final List<Pattern> IGNORABLE_ERROR_MESSAGE_PATTERNS = Arrays.asList(Pattern.compile("Failed to import bean definitions from relative location \\[(.*)\\]:.*"), Pattern.compile("Failed to import bean definitions from URL location \\[(.*)\\]:.*"));

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof BeansConfig && context instanceof IBeansValidationContext;
    }

    public void validate(BeansConfig element, IBeansValidationContext context, IProgressMonitor monitor) {
        for (ValidationProblem problem : element.getProblems()) {
            if (this.isMessageIgnorable(problem.getMessage())) continue;
            context.addProblems(new ValidationProblem[]{problem});
        }
    }

    private boolean isMessageIgnorable(String message) {
        for (Pattern pattern : IGNORABLE_ERROR_MESSAGE_PATTERNS) {
            if (!pattern.matcher(message).matches()) continue;
            return true;
        }
        return false;
    }
}

