/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.type.asm.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertyRule
extends AbstractBeanValidationRule {
    private static final String REQUIRED_ANNOTATION_TYPE_PROPERTY_NAME = "requiredAnnotationType";

    @Override
    protected boolean supportsBean(IBean bean, IBeansValidationContext context) {
        return !bean.isAbstract() && context.isBeanRegistered("org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class.getName());
    }

    @Override
    public void validate(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        String mergedClassName;
        BeanDefinition mergedBd = BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        IType type = ValidationRuleUtils.extractBeanClass(mergedBd, bean, mergedClassName = mergedBd.getBeanClassName(), context);
        if (type != null) {
            this.validatePropertyNames(type, bean, mergedBd, context);
        }
    }

    private void validatePropertyNames(IType type, IBean bean, BeanDefinition mergedBd, IBeansValidationContext context) {
        try {
            RequiredAnnotationMetadata annotationMetadata = this.getRequiredAnnotationMetadata(context.getClassReaderFactory(), bean, type, this.getRequiredAnnotationTypes(context));
            ArrayList<String> missingProperties = new ArrayList<String>();
            Set properties = Introspector.findAllWritableProperties((IType)type);
            for (IMethod property : properties) {
                String propertyName = java.beans.Introspector.decapitalize(property.getElementName().substring(3));
                if (!annotationMetadata.isRequiredProperty(propertyName) || mergedBd.getPropertyValues().getPropertyValue(propertyName) != null) continue;
                missingProperties.add(propertyName);
            }
            if (missingProperties.size() > 0) {
                String msg = this.buildExceptionMessage(missingProperties, bean.getElementName());
                context.error((IResourceModelElement)bean, "REQUIRED_PROPERTY_MISSING", msg, new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)type.getFullyQualifiedName()), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName()), new ValidationProblemAttribute("MISSING_PROPERTIES", missingProperties)});
            }
        }
        catch (JavaModelException e) {
            BeansCorePlugin.log(e);
        }
    }

    private RequiredAnnotationMetadata getRequiredAnnotationMetadata(ClassReaderFactory classReaderFactory, IBean bean, IType type, Set<String> requiredAnnotationTypes) {
        String className = type.getFullyQualifiedName();
        RequiredAnnotationMetadata visitor = new RequiredAnnotationMetadata(requiredAnnotationTypes);
        try {
            while (className != null && !Object.class.getName().equals(className)) {
                ClassReader classReader = classReaderFactory.getClassReader(className);
                classReader.accept((ClassVisitor)visitor, 0);
                className = visitor.getSuperClassName();
            }
        }
        catch (IOException iOException) {}
        return visitor;
    }

    private Set<String> getRequiredAnnotationTypes(IBeansValidationContext context) {
        HashSet<String> requiredAnnotationTypes = new HashSet<String>();
        Set<BeanDefinition> bds = context.getRegisteredBeanDefinition("org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class.getName());
        for (BeanDefinition bd : bds) {
            PropertyValue property = bd.getPropertyValues().getPropertyValue(REQUIRED_ANNOTATION_TYPE_PROPERTY_NAME);
            if (property != null && property.getValue() instanceof TypedStringValue) {
                requiredAnnotationTypes.add(((TypedStringValue)property.getValue()).getValue());
                continue;
            }
            requiredAnnotationTypes.add(Required.class.getName());
        }
        return requiredAnnotationTypes;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        int size = invalidProperties.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size == 1 ? "Property" : "Properties");
        int i = 0;
        while (i < size) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '").append(propertyName).append("'");
            ++i;
        }
        sb.append(size == 1 ? " is" : " are");
        sb.append(" required for bean '").append(beanName).append("'");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredAnnotationMetadata
    extends AnnotationMetadataReadingVisitor {
        private Set<String> requiredAnnotationTypes = new HashSet<String>();
        private Set<String> requiredPropertyNames = new HashSet<String>();

        public RequiredAnnotationMetadata(Set<String> requiredAnnotationTypes) {
            for (String className : requiredAnnotationTypes) {
                this.requiredAnnotationTypes.add(String.valueOf('L') + className.replace('.', '/') + ';');
            }
        }

        public MethodVisitor visitMethod(int modifier, final String name, String params, String arg3, String[] arg4) {
            if (name.startsWith("set")) {
                return new EmptyMethodVisitor(){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (RequiredAnnotationMetadata.this.requiredAnnotationTypes.contains(desc)) {
                            RequiredAnnotationMetadata.this.requiredPropertyNames.add(java.beans.Introspector.decapitalize(name.substring(3)));
                        }
                        return new EmptyAnnotationVisitor();
                    }
                };
            }
            return new EmptyMethodVisitor();
        }

        public boolean isRequiredProperty(String propertyName) {
            return this.requiredPropertyNames.contains(propertyName);
        }
    }
}

