/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractXmlValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceElementsRule
extends AbstractXmlValidationRule {
    private final List<IAttributeValidator> ATTRIBUTE_VALIDATORS = new ArrayList<IAttributeValidator>();
    private final List<IElementValidator> ELEMENT_VALIDATORS;
    private List<String> ignorableClasses;
    private List<String> ignorableBeans;

    public NamespaceElementsRule() {
        this.ATTRIBUTE_VALIDATORS.add(new UtilStaticFieldAttributeValidator());
        this.ATTRIBUTE_VALIDATORS.add(new BlueprintInterfaceAttributeValidator());
        this.ATTRIBUTE_VALIDATORS.add(new BlueprintDependesOnAttributeValidator());
        this.ELEMENT_VALIDATORS = new ArrayList<IElementValidator>();
        this.ELEMENT_VALIDATORS.add(new OsgiInterfacesElementValidator());
        this.ignorableClasses = null;
        this.ignorableBeans = new ArrayList<String>();
    }

    public void setIgnorableClasses(String classNames) {
        if (StringUtils.hasText((String)classNames)) {
            this.ignorableClasses = Arrays.asList(StringUtils.delimitedListToStringArray((String)classNames, (String)",", (String)"\r\n\f "));
        }
    }

    public void setIgnorableBeans(String beanNames) {
        if (StringUtils.hasText((String)beanNames)) {
            this.ignorableBeans = Arrays.asList(StringUtils.delimitedListToStringArray((String)beanNames, (String)",", (String)"\r\n\f "));
        }
    }

    protected boolean supports(Node n) {
        return n.getNodeType() == 1 && !"http://www.springframework.org/schema/beans".equals(n.getNamespaceURI());
    }

    protected void validate(Node n, IXmlValidationContext context) {
        this.validate(n, null, context);
    }

    public void validate(Node n, String attributeNameToCheck, IXmlValidationContext context) {
        NamedNodeMap attributes;
        if (attributeNameToCheck == null) {
            for (IElementValidator validator : this.ELEMENT_VALIDATORS) {
                if (!validator.supports(n)) continue;
                validator.validate(n, context);
            }
        }
        if ((attributes = n.getAttributes()) != null && attributes.getLength() > 0) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attributeName = attribute.getLocalName();
                if (attributeNameToCheck == null || attributeNameToCheck.equals(attributeName)) {
                    for (ToolAnnotationUtils.ToolAnnotationData annotationData : context.getToolAnnotation(n, attributeName)) {
                        if ("ref".equals(annotationData.getKind())) {
                            this.validateBeanReference(n, attribute, context);
                        }
                        if (Class.class.getName().equals(annotationData.getExpectedType())) {
                            this.validateClassName(n, attribute, context, annotationData);
                        }
                        if (annotationData.getExpectedMethodType() != null && attribute.getNodeValue() != null) {
                            this.validateMethodName(this.evaluateXPathExpression(annotationData.getExpectedMethodType(), n), n, attribute, context);
                            continue;
                        }
                        if (annotationData.getExpectedMethodRef() == null || attribute.getNodeValue() == null) continue;
                        try {
                            AbstractBeanDefinition referencedBeanDefinition = (AbstractBeanDefinition)context.getCompleteRegistry().getBeanDefinition(this.evaluateXPathExpression(annotationData.getExpectedMethodRef(), n));
                            String className = referencedBeanDefinition.getBeanClassName();
                            this.validateMethodName(className, n, attribute, context);
                        }
                        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
                    }
                    for (IAttributeValidator validator : this.ATTRIBUTE_VALIDATORS) {
                        if (!validator.supports(n, attribute)) continue;
                        validator.validate(n, attribute, context);
                    }
                }
                ++i;
            }
        }
    }

    private void validateMethodName(String className, Node n, Node attribute, IXmlValidationContext context) {
        IType type = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)className);
        try {
            String methodName;
            if (type != null && Introspector.findMethod((IType)type, (String)(methodName = attribute.getNodeValue()), (int)-1, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE) == null) {
                context.error(n, "METHOD_NOT_FOUND", "Method '" + methodName + "' not found in class '" + className + "'", new ValidationProblemAttribute("METHOD", (Object)methodName), new ValidationProblemAttribute("CLASS", (Object)className));
            }
        }
        catch (Exception e) {
            SpringCore.log((Throwable)e);
        }
    }

    private void validateClassName(Node n, Node attribute, IXmlValidationContext context, ToolAnnotationUtils.ToolAnnotationData annotationData) {
        String className = attribute.getNodeValue();
        if (className != null && !SpringCoreUtils.hasPlaceHolder((String)className) && !this.ignorableClasses.contains(className)) {
            IType type = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)className);
            if (type == null || type.getDeclaringType() != null && className.indexOf(36) == -1) {
                context.error(n, "CLASS_NOT_FOUND", "Class '" + className + "' not found", new ValidationProblemAttribute("CLASS", (Object)className));
                return;
            }
            try {
                if (annotationData.getAssignableTo() != null && !JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)annotationData.getAssignableTo())) {
                    context.error(n, "CLASS_IS_NOT_IN_HIERACHY", "'" + className + "' is not a sub type of '" + annotationData.getAssignableTo() + "'", new ValidationProblemAttribute[0]);
                }
                if ("class-only".equals(annotationData.getAssignableToRestriction()) && type.isInterface()) {
                    context.error(n, "CLASS_IS_INTERFACE", "'" + className + "' specifies an interface where a class is required", new ValidationProblemAttribute[0]);
                } else if ("interface-only".equals(annotationData.getAssignableToRestriction()) && !type.isInterface()) {
                    context.error(n, "CLASS_IS_CLASS", "'" + className + "' specifies a class where an interface is required", new ValidationProblemAttribute[0]);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateBeanReference(Node n, Node attribute, IXmlValidationContext context) {
        block7: {
            beanName = attribute.getNodeValue();
            if (beanName != null && !SpringCoreUtils.hasPlaceHolder((String)beanName) && !this.ignorableBeans.contains(beanName)) {
                try {
                    context.getCompleteRegistry().getBeanDefinition(beanName);
                    break block7;
                }
                catch (NoSuchBeanDefinitionException v0) {
                    context.warning(n, "UNDEFINED_REFERENCED_BEAN", "Referenced bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName)});
                    break block7;
                }
                catch (BeanDefinitionStoreException e) {
                    exp = e;
                    placeHolderFound = false;
                    ** while (exp != null && exp.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    msg = exp.getCause().getMessage();
                    if (msg.contains("${") && msg.contains("}")) {
                        placeHolderFound = true;
                        break;
                    }
                    exp = exp.getCause();
                    continue;
                }
lbl20:
                // 2 sources

                if (!placeHolderFound) {
                    context.warning(n, "UNDEFINED_REFERENCED_BEAN", "Refrenced bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName)});
                }
            }
        }
    }

    private String evaluateXPathExpression(String xpath, Node node) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        try {
            return path.evaluate(xpath, node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    private class BlueprintDependesOnAttributeValidator
    implements IAttributeValidator {
        private BlueprintDependesOnAttributeValidator() {
        }

        public boolean supports(Node n, Node attribute) {
            return "http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(n.getNamespaceURI()) && "depends-on".equals(attribute.getLocalName());
        }

        public void validate(Node n, Node attribute, IXmlValidationContext context) {
            NamespaceElementsRule.this.validateBeanReference(n, attribute, context);
        }
    }

    private class BlueprintInterfaceAttributeValidator
    implements IAttributeValidator {
        private final ToolAnnotationUtils.ToolAnnotationData annotationData = new ToolAnnotationUtils.ToolAnnotationData();

        public BlueprintInterfaceAttributeValidator() {
            this.annotationData.setAssignableToRestriction("interface-only");
        }

        public boolean supports(Node n, Node attribute) {
            return "http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(n.getNamespaceURI()) && "interface".equals(attribute.getLocalName());
        }

        public void validate(Node n, Node attribute, IXmlValidationContext context) {
            NamespaceElementsRule.this.validateClassName(n, attribute, context, this.annotationData);
        }
    }

    static interface IAttributeValidator {
        public boolean supports(Node var1, Node var2);

        public void validate(Node var1, Node var2, IXmlValidationContext var3);
    }

    static interface IElementValidator {
        public boolean supports(Node var1);

        public void validate(Node var1, IXmlValidationContext var2);
    }

    private class OsgiInterfacesElementValidator
    implements IElementValidator {
        private OsgiInterfacesElementValidator() {
        }

        public boolean supports(Node n) {
            return ("http://www.springframework.org/schema/osgi".equals(n.getNamespaceURI()) || "http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(n.getNamespaceURI())) && "interfaces".equals(n.getLocalName());
        }

        public void validate(Node n, IXmlValidationContext context) {
            NodeList children = n.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1 && "value".equals(child.getLocalName()) && child.getFirstChild() != null && child.getFirstChild().getNodeType() == 3) {
                    String className = child.getFirstChild().getNodeValue();
                    IType type = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)className);
                    if (type == null || type.getDeclaringType() != null && className.indexOf(36) == -1) {
                        context.error(child, "CLASS_NOT_FOUND", "Class '" + className + "' not found", new ValidationProblemAttribute("Class", (Object)className));
                    } else {
                        try {
                            if (!type.isInterface()) {
                                context.error(child, "CLASS_IS_CLASS", "'" + className + "' specifies a class where an interface is required", new ValidationProblemAttribute[0]);
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
                ++i;
            }
        }
    }

    private class UtilStaticFieldAttributeValidator
    implements IAttributeValidator {
        private UtilStaticFieldAttributeValidator() {
        }

        public boolean supports(Node n, Node attribute) {
            return "http://www.springframework.org/schema/util".equals(n.getNamespaceURI()) && "constant".equals(n.getLocalName()) && "static-field".equals(attribute.getNodeName());
        }

        public void validate(Node n, Node attribute, IXmlValidationContext context) {
            try {
                int ix;
                String fieldName = attribute.getNodeValue();
                if (fieldName != null && (ix = fieldName.lastIndexOf(46)) > 0) {
                    String className = fieldName.substring(0, ix);
                    fieldName = fieldName.substring(ix + 1);
                    IType type = JdtUtils.getJavaType((IProject)context.getRootElementProject(), (String)className);
                    if (type != null) {
                        IField field = type.getField(fieldName);
                        if (!field.exists()) {
                            context.error(n, "FIELD_NOT_FOUND", "Field '" + fieldName + "' not found on class '" + className + "'", new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("FIELD", (Object)fieldName));
                        } else if (!type.isEnum() && !Flags.isStatic((int)field.getFlags())) {
                            context.error(n, "FIELD_NOT_STATIC", "Field '" + fieldName + "' on class '" + className + "' is not static", new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("FIELD", (Object)fieldName));
                        }
                    } else {
                        context.error(n, "CLASS_NOT_FOUND", "Class '" + className + "' not found", new ValidationProblemAttribute("CLASS", (Object)className));
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

