/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleDelegatingClassLoader
extends ClassLoader {
    private static final String NULL_STRING = "null";
    private static final Enumeration<URL> EMPTY_RESOURCES = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    };
    private final ClassLoader bridge;
    private final Bundle backingBundle;

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(Bundle aBundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(aBundle, null);
    }

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(final Bundle bundle, final ClassLoader bridge) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleDelegatingClassLoader>(){

            @Override
            public BundleDelegatingClassLoader run() {
                return new BundleDelegatingClassLoader(bundle, bridge);
            }
        });
    }

    protected BundleDelegatingClassLoader(Bundle bundle, ClassLoader bridgeLoader) {
        super(null);
        Assert.notNull((Object)bundle, (String)"bundle should be non-null");
        this.backingBundle = bundle;
        this.bridge = bridgeLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.backingBundle.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassNotFoundException(String.valueOf(name) + " not found from bundle [" + this.backingBundle.getSymbolicName() + "]", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            NoClassDefFoundError e = new NoClassDefFoundError(String.valueOf(name) + " not found from bundle [" + this.nullSafeNameAndSymName(this.backingBundle) + "]");
            e.initCause(ncdfe);
            throw e;
        }
    }

    @Override
    protected URL findResource(String name) {
        URL url = this.backingBundle.getResource(name);
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enm = this.backingBundle.getResources(name);
        return enm;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = this.backingBundle.getResources(name);
        if (this.bridge != null) {
            Enumeration<URL> bridgeResources = this.bridge.getResources(name);
            if (resources == null) {
                resources = bridgeResources;
            } else if (bridgeResources != null) {
                resources = new CombinedEnumeration<URL>(resources, bridgeResources);
            }
        }
        return resources != null ? resources : EMPTY_RESOURCES;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (this.bridge != null && resource == null) {
            resource = this.bridge.getResource(name);
        }
        return resource;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.bridge != null) {
                clazz = this.bridge.loadClass(name);
            }
            throw cnfe;
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public String toString() {
        return "BundleDelegatingClassLoader for [" + this.nullSafeNameAndSymName(this.backingBundle) + "]";
    }

    public Bundle getBundle() {
        return this.backingBundle;
    }

    protected String nullSafeNameAndSymName(Bundle bundle) {
        if (bundle == null) {
            return NULL_STRING;
        }
        Dictionary dict = bundle.getHeaders();
        if (dict == null) {
            return NULL_STRING;
        }
        StringBuilder buf = new StringBuilder();
        String name = (String)dict.get("Bundle-Name");
        if (name == null) {
            buf.append(NULL_STRING);
        } else {
            buf.append(name);
        }
        buf.append(" (");
        String sname = (String)dict.get("Bundle-SymbolicName");
        if (sname == null) {
            buf.append(NULL_STRING);
        } else {
            buf.append(sname);
        }
        buf.append(")");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T> e1;
        private final Enumeration<T> e2;

        public CombinedEnumeration(Enumeration<T> e1, Enumeration<T> e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e1.hasMoreElements() || this.e2.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.e1.hasMoreElements()) {
                return this.e1.nextElement();
            }
            if (this.e2.hasMoreElements()) {
                return this.e2.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

