/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeansTypedString
extends AbstractBeansModelElement
implements IBeansTypedString {
    private String value;
    private String targetTypeName;

    public BeansTypedString(IModelElement parent, TypedStringValue stringValue) {
        super(parent, "(typed string)", (BeanMetadataElement)stringValue);
        this.value = stringValue.getValue();
        this.targetTypeName = stringValue.getTargetTypeName();
    }

    public BeansTypedString(ISourceModelElement parent, String stringValue) {
        super((IModelElement)parent, "(typed string)", parent.getElementSourceLocation());
        this.value = stringValue;
    }

    public int getElementType() {
        return 17;
    }

    public String getString() {
        return this.value;
    }

    public String getTargetTypeName() {
        return this.targetTypeName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansTypedString)) {
            return false;
        }
        BeansTypedString that = (BeansTypedString)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.targetTypeName, (Object)that.targetTypeName)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.value);
        hashCode = this.getElementType() * hashCode + ObjectUtils.nullSafeHashCode((Object)this.targetTypeName);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": value=");
        text.append(this.value);
        if (StringUtils.hasText((String)this.targetTypeName)) {
            text.append(" (");
            text.append(this.targetTypeName);
            text.append(')');
        }
        return text.toString();
    }
}

