/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansSet
extends AbstractBeansModelElement
implements IBeansSet {
    private LinkedHashSet<Object> set = new LinkedHashSet();

    public BeansSet(IModelElement parent, ManagedSet<?> set) {
        super(parent, "(set)", (BeanMetadataElement)set);
        for (Object value : set) {
            this.set.add(BeansModelUtils.resolveValueIfNecessary(this, value));
        }
    }

    public int getElementType() {
        return 13;
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IModelElement> children = new ArrayList<IModelElement>();
        for (Object e : this.set) {
            if (!(e instanceof IModelElement)) continue;
            children.add((IModelElement)e);
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (Object e : this.set) {
                if (!(e instanceof IModelElement)) continue;
                ((IModelElement)e).accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    public Set<Object> getSet() {
        return this.set;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansSet)) {
            return false;
        }
        BeansSet that = (BeansSet)other;
        if (!ObjectUtils.nullSafeEquals(this.set, that.set)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.set);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": set=");
        text.append(this.set);
        return text.toString();
    }
}

