/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansList
extends AbstractBeansModelElement
implements IBeansList {
    private List<Object> list = new ArrayList<Object>();

    public BeansList(IModelElement parent, ManagedList<?> list) {
        super(parent, "(list)", (BeanMetadataElement)list);
        for (Object value : list) {
            this.list.add(BeansModelUtils.resolveValueIfNecessary(this, value));
        }
    }

    public int getElementType() {
        return 12;
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IModelElement> children = new ArrayList<IModelElement>();
        for (Object value : this.list) {
            if (!(value instanceof IModelElement)) continue;
            children.add((IModelElement)value);
        }
        return children.toArray(new IModelElement[children.size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (Object value : this.list) {
                if (!(value instanceof IModelElement)) continue;
                ((IModelElement)value).accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    public List<Object> getList() {
        return this.list;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansList)) {
            return false;
        }
        BeansList that = (BeansList)other;
        if (!ObjectUtils.nullSafeEquals(this.list, that.list)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.list);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": list=");
        text.append(this.list);
        return text.toString();
    }
}

